/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.cache.rest;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OhNo {
    private static final Logger log = LoggerFactory.getLogger(OhNo.class);

    private OhNo() {
        throw new IllegalStateException("Singleton class!");
    }

    public static void logThreadDump(String errorMessage) {
        String threadDump = OhNo.getThreadDump();
        if (threadDump == null) {
            log.info("{}. Could not write thread dump.", (Object)errorMessage);
        } else {
            log.info("{} \nThreads:\n{}", (Object)errorMessage, (Object)threadDump);
        }
    }

    public static String getThreadDump() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean == null) {
            return null;
        }
        ThreadInfo[] threads = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), Integer.MAX_VALUE);
        if (threads == null || threads.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (ThreadInfo thread : threads) {
            OhNo.writeThreadDump(thread, builder);
        }
        return builder.toString();
    }

    public static void writeThreadDump(ThreadInfo threadInfo, StringBuilder out) {
        if (threadInfo == null) {
            return;
        }
        out.append("\"").append(threadInfo.getThreadName()).append("\"").append(" id=").append(threadInfo.getThreadId()).append(' ').append((Object)threadInfo.getThreadState());
        if (threadInfo.getLockName() != null) {
            out.append(" on ").append(threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            out.append(" owned by \"").append(threadInfo.getLockOwnerName()).append(" id=").append(threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            out.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            out.append(" (in native)");
        }
        out.append('\n');
        LockInfo lockInfo = threadInfo.getLockInfo();
        Thread.State threadState = threadInfo.getThreadState();
        MonitorInfo[] lockedMonitors = threadInfo.getLockedMonitors();
        StackTraceElement[] stackTrace = threadInfo.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement frame = stackTrace[i];
            out.append("\tat ").append(frame).append('\n');
            if (i == 0 && lockInfo != null) {
                switch (threadState) {
                    case BLOCKED: {
                        out.append("\t-  blocked on ");
                        break;
                    }
                    case WAITING: {
                        out.append("\t-  waiting on ");
                        break;
                    }
                    case TIMED_WAITING: {
                        out.append("\t-  waiting on ");
                        break;
                    }
                }
                out.append(lockInfo).append('\n');
            }
            MonitorInfo[] monitorInfoArray = lockedMonitors;
            int n = monitorInfoArray.length;
            for (int j = 0; j < n; ++j) {
                MonitorInfo monitor = monitorInfoArray[j];
                if (monitor.getLockedStackDepth() != i) continue;
                out.append("\t-  locked ").append(monitor).append("\n");
            }
        }
        LockInfo[] locks = threadInfo.getLockedSynchronizers();
        if (locks.length > 0) {
            out.append("\n\tNumber of locked synchronizers = ").append(locks.length).append('\n');
            for (LockInfo lock : locks) {
                out.append("\t- ").append(lock).append('\n');
            }
        }
        out.append('\n');
    }
}

