/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.cache.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.scm.cache.ScmCacheConfig;
import com.atlassian.bitbucket.scm.cache.ScmRequestProtocol;
import com.atlassian.bitbucket.scm.cache.ScmRequestType;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Locale;

@AdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Path(value="config")
public class ScmCacheConfigResource {
    private final ScmCacheConfig config;

    @Inject
    public ScmCacheConfigResource(ScmCacheConfig config) {
        this.config = config;
    }

    @GET
    @Path(value="{requestType}/enabled")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response isEnabled(@PathParam(value="requestType") String requestType) {
        ScmRequestType type = ScmRequestType.forName((String)requestType);
        return ResponseFactory.ok().entity((Object)this.config.isEnabled(type)).build();
    }

    @GET
    @Path(value="{requestType}/max-count")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMaxCount(@PathParam(value="requestType") String requestType) {
        ScmRequestType type = ScmRequestType.forName((String)requestType);
        return ResponseFactory.ok().entity((Object)this.config.getMaxCount(type)).build();
    }

    @GET
    @Path(value="{requestType}/ttl")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getTimeToLive(@PathParam(value="requestType") String requestType) {
        ScmRequestType type = ScmRequestType.forName((String)requestType);
        return ResponseFactory.ok().entity((Object)this.config.getTimeToLive(type)).build();
    }

    @PUT
    @Path(value="{requestType}/enabled/{value}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setEnabled(@PathParam(value="requestType") String requestType, @PathParam(value="value") boolean enabled) {
        ScmRequestType type = ScmRequestType.forName((String)requestType);
        this.config.setEnabled(type, enabled);
        return ResponseFactory.noContent().build();
    }

    @PUT
    @Path(value="{requestType}/max-count/{value}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setMaxCount(@PathParam(value="requestType") String requestType, @PathParam(value="value") int maxCount) {
        ScmRequestType type = ScmRequestType.forName((String)requestType);
        this.config.setMaxCount(type, maxCount);
        return ResponseFactory.noContent().build();
    }

    @PUT
    @Path(value="{requestType}/ttl/{value}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setTimeToLive(@PathParam(value="requestType") String requestType, @PathParam(value="value") String ttl) {
        try {
            ScmRequestType type = ScmRequestType.forName((String)requestType);
            this.config.setTimeToLive(type, Long.parseLong(ttl));
            return ResponseFactory.noContent().build();
        }
        catch (NumberFormatException e) {
            return ResponseFactory.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RestErrors("Not a number: " + ttl)).build();
        }
    }

    @GET
    @Path(value="protocols")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSupportedProtocols() {
        return ResponseFactory.ok((Object)this.config.getEnabledProtocols()).build();
    }

    @PUT
    @Path(value="protocols/{value}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response enableProtocol(@PathParam(value="value") String protocol) {
        return this.setProtocolEnabled(protocol, true);
    }

    @DELETE
    @Path(value="protocols/{value}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response disableProtocol(@PathParam(value="value") String protocol) {
        return this.setProtocolEnabled(protocol, false);
    }

    private Response setProtocolEnabled(String protocol, boolean enable) {
        try {
            this.config.setEnabled(ScmRequestProtocol.valueOf((String)protocol.toUpperCase(Locale.US)), enable);
            return ResponseFactory.noContent().build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }
}

