/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.cache.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.scm.cache.CacheStatistics;
import com.atlassian.bitbucket.scm.cache.ScmCacheService;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.scm.git.cache.rest.RestCacheStatistics;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Path(value="caches")
public class ScmCacheResource {
    private final ScmCacheService cacheService;
    private final I18nService i18nService;
    private final RepositoryService repositoryService;

    @Inject
    public ScmCacheResource(ScmCacheService cacheService, I18nService i18nService, RepositoryService repositoryService) {
        this.cacheService = cacheService;
        this.i18nService = i18nService;
        this.repositoryService = repositoryService;
    }

    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response clear() {
        this.cacheService.clear();
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @Path(value="{projectKey}/{repositorySlug}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response clearRegion(@PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repoSlug) {
        this.cacheService.clear(this.getRepository(projectKey, repoSlug));
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @Path(value="{projectKey}/{repositorySlug}/{cacheKey}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response clearRegion(@PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repoSlug, @PathParam(value="cacheKey") String cacheKey) {
        this.cacheService.clear(this.getRepository(projectKey, repoSlug), cacheKey);
        return ResponseFactory.noContent().build();
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getStatus() {
        CacheStatistics status = this.cacheService.getStatistics();
        return ResponseFactory.ok().entity((Object)new RestCacheStatistics(status)).build();
    }

    @GET
    @Path(value="{projectKey}/{repositorySlug}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getStatus(@PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repoSlug) {
        CacheStatistics status = this.cacheService.getStatistics(this.getRepository(projectKey, repoSlug));
        if (status == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.git.rest.cache.nosuchregion", new Object[]{projectKey, repoSlug}));
        }
        return ResponseFactory.ok().entity((Object)new RestCacheStatistics(status)).build();
    }

    private Repository getRepository(String projectKey, String repoSlug) {
        Repository repository = this.repositoryService.getBySlug(projectKey, repoSlug);
        if (repository == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.git.rest.cache.nosuchrepository", new Object[]{projectKey, repoSlug});
            throw new NoSuchRepositoryException(message, null);
        }
        return repository;
    }
}

