/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.ref;

import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.event.tag.TagCreatedEvent;
import com.atlassian.bitbucket.event.tag.TagCreationHookRequest;
import com.atlassian.bitbucket.event.tag.TagDeletedEvent;
import com.atlassian.bitbucket.event.tag.TagDeletionHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookVetoedException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.IllegalRepositoryStateException;
import com.atlassian.bitbucket.repository.NoSuchTagException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.SimpleTag;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scm.git.command.GitRefCommandFactory;
import com.atlassian.bitbucket.scm.git.ref.GitCreateTagCommandParameters;
import com.atlassian.bitbucket.scm.git.ref.GitDeleteTagCommandParameters;
import com.atlassian.bitbucket.scm.ref.CreateTagCommandParameters;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.scm.git.ref.GitRefService;
import jakarta.annotation.Nonnull;

public class DefaultGitRefService
implements GitRefService {
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final RefService refService;
    private final GitRefCommandFactory refCommandFactory;
    private final RepositoryHookService repositoryHookService;
    private final RepositoryService repositoryService;

    public DefaultGitRefService(I18nService i18nService, PermissionService permissionService, GitRefCommandFactory refCommandFactory, RefService refService, RepositoryHookService repositoryHookService, RepositoryService repositoryService, EventPublisher eventPublisher) {
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.refCommandFactory = refCommandFactory;
        this.refService = refService;
        this.repositoryHookService = repositoryHookService;
        this.repositoryService = repositoryService;
        this.eventPublisher = eventPublisher;
    }

    @Override
    @Nonnull
    public Tag createTag(@Nonnull Repository repository, @Nonnull GitCreateTagCommandParameters parameters) {
        this.validateIsGitRepo(repository);
        this.validateRepoPerms(repository);
        this.validateRepoIsNotEmpty(repository);
        TagCreationHookRequest request = new TagCreationHookRequest.Builder(repository, (Tag)DefaultGitRefService.simpleTag(parameters)).build();
        RepositoryHookResult result = this.repositoryHookService.preUpdate((RepositoryHookRequest)request);
        if (result.isRejected()) {
            throw new RepositoryHookVetoedException(this.i18nService.createKeyedMessage("bitbucket.service.tag.creationcanceled", new Object[0]), (RepositoryHookRequest)request, result.getVetoes());
        }
        Tag tag = (Tag)this.refCommandFactory.createTag(repository, (CreateTagCommandParameters)parameters).call();
        if (tag == null) {
            throw new NoSuchTagException(this.i18nService.createKeyedMessage("bitbucket.service.tag.creationerror", new Object[]{parameters.getName()}), parameters.getName());
        }
        this.eventPublisher.publish((Object)new TagCreatedEvent((Object)this, repository, tag));
        return tag;
    }

    @Override
    public void deleteTag(@Nonnull Repository repository, @Nonnull GitDeleteTagCommandParameters parameters) {
        this.validateRepoPerms(repository);
        this.validateIsGitRepo(repository);
        ResolveRefRequest request = new ResolveRefRequest.Builder(repository).refId(GitRefPattern.TAGS.qualify(parameters.getName())).build();
        Tag tag = (Tag)Tag.class.cast(this.refService.resolveRef(request));
        if (tag == null) {
            throw new NoSuchTagException(this.i18nService.createKeyedMessage("bitbucket.git.tag.delete.error", new Object[]{parameters.getName()}), parameters.getName());
        }
        TagDeletionHookRequest hookRequest = new TagDeletionHookRequest.Builder(repository, tag).build();
        RepositoryHookResult result = this.repositoryHookService.preUpdate((RepositoryHookRequest)hookRequest);
        if (result.isRejected()) {
            throw new RepositoryHookVetoedException(this.i18nService.createKeyedMessage("bitbucket.git.tag.delete.cancelled", new Object[0]), (RepositoryHookRequest)hookRequest, result.getVetoes());
        }
        this.refCommandFactory.deleteTag(repository, parameters).call();
        this.eventPublisher.publish((Object)new TagDeletedEvent((Object)this, repository, tag));
    }

    private void validateIsGitRepo(Repository repository) {
        if (!"git".equals(repository.getScmId())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.service.tag.notgit", new Object[0]));
        }
    }

    private void validateRepoPerms(Repository repository) {
        if (!this.permissionService.hasRepositoryPermission(repository, Permission.REPO_WRITE)) {
            throw new ForbiddenException(this.i18nService.createKeyedMessage("bitbucket.git.service.tag.unauthorized", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
    }

    private void validateRepoIsNotEmpty(Repository repository) {
        if (this.repositoryService.isEmpty(repository)) {
            throw new IllegalRepositoryStateException(this.i18nService.createKeyedMessage("bitbucket.git.service.tag.creation.emptyrepository", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
    }

    private static SimpleTag simpleTag(@Nonnull GitCreateTagCommandParameters parameters) {
        return ((SimpleTag.Builder)((SimpleTag.Builder)((SimpleTag.Builder)new SimpleTag.Builder().id(GitRefPattern.TAGS.qualify(parameters.getName()))).displayId(parameters.getName())).latestCommit(parameters.getStartPoint())).build();
    }
}

