/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.rest.pull;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.scm.git.pull.GitPullRequestService;
import com.atlassian.bitbucket.scm.git.pull.PullRequestRebaseRequest;
import com.atlassian.bitbucket.scm.git.pull.PullRequestRebaseability;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.scm.git.rest.pull.RestPullRequestRebaseRequest;
import com.atlassian.stash.internal.scm.git.rest.pull.RestPullRequestRebaseResult;
import com.atlassian.stash.internal.scm.git.rest.pull.RestPullRequestRebaseability;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug."), @PathParamDoc(name="pullRequestId", documentation="The ID of the pull request within the repository.")})
@Tag(name="Pull Requests")
@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class GitPullRequestResource {
    private final GitPullRequestService gitPullRequestService;
    private final I18nService i18nService;

    @Inject
    public GitPullRequestResource(GitPullRequestService gitPullRequestService, I18nService i18nService) {
        this.gitPullRequestService = gitPullRequestService;
        this.i18nService = i18nService;
    }

    @Operation(description="Checks preconditions to determine whether the pull request can be rebased.\n\nSome of the preconditions are:\n\n- The pull request is between Git repositories\n- The pull request is currently open\n- The pull request's {@link PullRequest#getFromRef \"from\" ref} is a <i>branch</i>\n   - In other words, the qualified ID for the \"from\" ref must start with <code>refs/heads/</code>\n   - Tags, and other non-standard refs, cannot be rebased\n- The current user has an e-mail address\n   - Pull requests cannot be rebased anonymously\n   - `git rebase` records the current user as the committer for the rebased commits, which        requires a name and e-mail address\n- The current user has <i>write</i> access to the {@link PullRequest#getFromRef \"from\" ref}'s repository\n   - Note that in order to <i>view</i> a pull request a user is only required to have <i>read</i>      access to the {@link PullRequest#getToRef toRef}'s repository, so just because a user can <i>see</i>      a pull request does not mean they can request a rebase\n\n\nThis list is not exhaustive, and the exact set of preconditions applied can be extended by third-party add-ons.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Check PR rebase precondition")
    @ResponseDocs(value={@ResponseDoc(documentation="The rebaseability status of the pull request.", representation=RestPullRequestRebaseability.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="rebase")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response canRebase(@BeanParam PullRequestResolver pullRequestResolver) {
        PullRequestRebaseability rebaseability = this.gitPullRequestService.canRebase(pullRequestResolver.getPullRequest());
        return ResponseFactory.ok((Object)((Object)new RestPullRequestRebaseability(rebaseability))).build();
    }

    @Operation(description="Rebases the specified pull request, rewriting the incoming commits to start from the tip commit of the pull request's target branch. <i>This operation alters the pull request's source branch and cannot be undone.</i>\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets <i>and</i> <strong>REPO_WRITE</strong> permission for the pull request's source repository to call this resource.", summary="Rebase pull request")
    @ResponseDocs(value={@ResponseDoc(documentation="The merged pull request.", representation=RestPullRequestRebaseResult.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the pull request and/or to update its source branch.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="Any of the following error cases occurred (check the error message for more details):\n\n- The rebase encountered conflicts.\n- The rebase discarded all of the incoming commits and would have left the pull request empty\n- A <tt>PreRepositoryHook</tt> vetoed the rebase.\n- The specified version is out of date.\n- The specified pull request is not open.\n- The target repository is archived.", responseCode=409, restError=true)})
    @RequestBody(description="The pull request rebase request.", content={@Content(schema=@Schema(implementation=RestPullRequestRebaseRequest.class))})
    @Path(value="rebase")
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response rebase(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId, @Nonnull RestPullRequestRebaseRequest request) {
        if (!request.hasVersion()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.rest.pullrequest.rebase.versionrequired", new Object[0]));
        }
        return this.gitPullRequestService.rebase(new PullRequestRebaseRequest.Builder(repositoryResolver.getRepository().getId(), pullRequestId, request.getVersion()).build()).map(RestPullRequestRebaseResult::new).map(ResponseFactory::ok).orElseGet(ResponseFactory::noContent).build();
    }
}

