/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.rest.pull;

import com.atlassian.bitbucket.dmz.rest.v2.hook.repository.RestRepositoryHookVeto;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.scm.git.pull.PullRequestRebaseability;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;

@JsonSerialize
@JsonSurrogate(value=PullRequestRebaseability.class)
public class RestPullRequestRebaseability
extends RestMapEntity {
    private static final String CAN_REBASE = "canRebase";
    private static final String CAN_WRITE = "canWrite";
    private static final String VETOES = "vetoes";

    public RestPullRequestRebaseability(PullRequestRebaseability rebaseability) {
        this.put(CAN_REBASE, rebaseability.canRebase());
        this.put(CAN_WRITE, rebaseability.canWrite());
        this.put(VETOES, rebaseability.getVetoes().stream().map(RestRepositoryHookVeto::new).collect(MoreCollectors.toImmutableList()));
    }

    public boolean canRebase() {
        return this.getBoolProperty(CAN_REBASE);
    }

    public boolean canWrite() {
        return this.getBoolProperty(CAN_WRITE);
    }

    public List<RestRepositoryHookVeto> getVetoes() {
        return (List)this.get(VETOES);
    }
}

