/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.rest.ref;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.repository.RestTag;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.scm.git.command.tag.GitTagType;
import com.atlassian.bitbucket.scm.git.ref.GitCreateTagCommandParameters;
import com.atlassian.bitbucket.scm.git.ref.GitDeleteTagCommandParameters;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.scm.git.ref.GitRefService;
import com.atlassian.stash.internal.scm.git.rest.ref.RestGitTagCreateRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Tag(name="Repository")
@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/tags")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class GitTagResource {
    private final GitRefService gitRefService;
    private final I18nService i18nService;

    @Inject
    public GitTagResource(GitRefService gitRefService, I18nService i18nService) {
        this.i18nService = i18nService;
        this.gitRefService = gitRefService;
    }

    @Operation(description="Creates a tag in the specified repository.\n\nThe authenticated user must have an effective <strong>REPO_WRITE</strong> permission to call this resource.\n\n'LIGHTWEIGHT' and 'ANNOTATED' are the two type of tags that can be created. The 'startPoint' can either be a ref or a 'commit'.", summary="Create tag")
    @ResponseDocs(value={@ResponseDoc(documentation="A JSON representation of the newly created tag.", representation=RestTag.class, responseCode=201), @ResponseDoc(documentation="The tag was not created because the request was invalid, e.g. the provided ref name already existed in the repository, or was not a valid ref name in the repository, or the start point is invalid.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to create a tag. This could be due to insufficient repository permissions.", responseCode=401, restError=true)})
    @RequestBody(description="The create git tag request.", content={@Content(schema=@Schema(implementation=RestGitTagCreateRequest.class))})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createTag(@BeanParam RepositoryResolver repositoryResolver, RestGitTagCreateRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getName())) {
            return ResponseFactory.errors((Response.Status)Response.Status.BAD_REQUEST, (RestErrors)new RestErrors(this.i18nService.getMessage("bitbucket.git.rest.tag.emptyname", new Object[0]))).build();
        }
        if (StringUtils.isBlank((CharSequence)request.getStartPoint())) {
            return ResponseFactory.errors((Response.Status)Response.Status.BAD_REQUEST, (RestErrors)new RestErrors(this.i18nService.getMessage("bitbucket.git.rest.tag.emptystartpoint", new Object[0]))).build();
        }
        return ResponseFactory.status((Response.Status)Response.Status.CREATED).entity((Object)new RestTag(this.gitRefService.createTag(repositoryResolver.getRepository(), this.createParameters(request)))).build();
    }

    @Operation(description="Deletes a tag in the specified repository.\n\nThe authenticated user must have an effective <strong>REPO_WRITE</strong> permission to call this resource.", summary="Delete tag")
    @Parameter(name="name", description="The name of the tag to be deleted.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="An empty response indicating that the tag no longer exists in the repository.", responseCode=204), @ResponseDoc(documentation="The tag was not deleted because repository is either empty, or is not a git repository.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete a tag. This could be due to insufficient repository permissions.", responseCode=401, restError=true), @ResponseDoc(documentation="If the tag doesn't exist in the repository.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="{name:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteTag(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="name") String name) {
        GitDeleteTagCommandParameters parameters = ((GitDeleteTagCommandParameters.Builder)new GitDeleteTagCommandParameters.Builder().name(name)).build();
        this.gitRefService.deleteTag(repositoryResolver.getRepository(), parameters);
        return ResponseFactory.noContent().build();
    }

    private GitCreateTagCommandParameters createParameters(RestGitTagCreateRequest request) {
        GitCreateTagCommandParameters.Builder builder = new GitCreateTagCommandParameters.Builder();
        GitTagType type = request.getType();
        if (type != null) {
            builder.type(type);
        }
        return ((GitCreateTagCommandParameters.Builder)((GitCreateTagCommandParameters.Builder)((GitCreateTagCommandParameters.Builder)builder.name(request.getName())).force(request.isForce().booleanValue()).message(request.getMessage())).startPoint(request.getStartPoint())).build();
    }
}

