/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.factories;

import com.atlassian.plugin.Application;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.factories.AbstractPluginFactory;
import com.atlassian.plugin.impl.XmlDynamicPlugin;
import com.atlassian.plugin.internal.parsers.XmlDescriptorParserFactory;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.function.Predicate;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class XmlDynamicPluginFactory
extends AbstractPluginFactory {
    private static final Logger log = LoggerFactory.getLogger(XmlDynamicPluginFactory.class);
    private static final Predicate<Integer> ALWAYS_TRUE = input -> true;

    public XmlDynamicPluginFactory(Application application) {
        this(Sets.newHashSet((Object[])new Application[]{application}));
    }

    public XmlDynamicPluginFactory(Set<Application> applications) {
        super(new XmlDescriptorParserFactory(), applications);
    }

    @Override
    protected InputStream getDescriptorInputStream(PluginArtifact pluginArtifact) {
        return pluginArtifact.getInputStream();
    }

    @Override
    protected Predicate<Integer> isValidPluginsVersion() {
        return ALWAYS_TRUE;
    }

    @Override
    public String canCreate(PluginArtifact pluginArtifact) {
        try {
            return super.canCreate(pluginArtifact);
        }
        catch (PluginParseException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DocumentException || cause instanceof SAXException) {
                log.debug("There was an error parsing the plugin descriptor for '{}'", (Object)pluginArtifact);
                log.debug("This is most probably because we parsed a jar, and the plugin is not an XML dynamic plugin. See the exception below for confirmation:", (Throwable)e);
                return null;
            }
            throw e;
        }
    }

    public Plugin create(PluginArtifact pluginArtifact, ModuleDescriptorFactory moduleDescriptorFactory) {
        Plugin plugin;
        Preconditions.checkNotNull((Object)pluginArtifact, (Object)"The plugin artifact must not be null");
        Preconditions.checkNotNull((Object)moduleDescriptorFactory, (Object)"The module descriptor factory must not be null");
        FileInputStream pluginDescriptor = new FileInputStream(pluginArtifact.toFile());
        try {
            DescriptorParser parser = this.descriptorParserFactory.getInstance(pluginDescriptor, this.applications);
            plugin = parser.configurePlugin(moduleDescriptorFactory, new XmlDynamicPlugin(pluginArtifact));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)pluginDescriptor).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException e) {
                throw new PluginParseException((Throwable)e);
            }
        }
        ((InputStream)pluginDescriptor).close();
        return plugin;
    }

    public ModuleDescriptor<?> createModule(Plugin plugin, Element module, ModuleDescriptorFactory moduleDescriptorFactory) {
        if (plugin instanceof XmlDynamicPlugin) {
            throw new PluginException("cannot create modules for an XmlDynamicPlugin");
        }
        return null;
    }
}

