/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PluginsInEnableOrder {
    private static Logger log = LoggerFactory.getLogger(PluginsInEnableOrder.class);
    final List<Plugin> sortedList = new ArrayList<Plugin>();

    public PluginsInEnableOrder(Collection<Plugin> pluginsToEnable, PluginRegistry.ReadOnly pluginRegistry) {
        HashSet<Plugin> visited = new HashSet<Plugin>();
        for (Plugin plugin : pluginsToEnable) {
            this.sortPluginForEnable(plugin, visited, pluginsToEnable, pluginRegistry);
        }
    }

    private void sortPluginForEnable(Plugin currentPlugin, Set<Plugin> visited, Collection<Plugin> allowedPlugins, PluginRegistry.ReadOnly pluginRegistry) {
        if (!visited.add(currentPlugin)) {
            return;
        }
        log.debug("Candidate plugin for adding to sorted list: {}", (Object)currentPlugin.getKey());
        for (String key : currentPlugin.getDependencies().getAll()) {
            Plugin requiredPlugin = pluginRegistry.get(key);
            if (null == requiredPlugin) continue;
            log.debug("Candidate plugin {} suspended - adding dependency {}", (Object)currentPlugin.getKey(), (Object)requiredPlugin.getKey());
            this.sortPluginForEnable(requiredPlugin, visited, allowedPlugins, pluginRegistry);
        }
        if (allowedPlugins.contains(currentPlugin)) {
            this.sortedList.add(currentPlugin);
            log.debug("Candidate plugin added to sorted list: {}", (Object)currentPlugin.getKey());
        }
    }

    public List<Plugin> get() {
        return Collections.unmodifiableList(this.sortedList);
    }
}

