/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.failurecache;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public class PlaceholderFuture<V>
implements Future<V> {
    private static final long TEN_SECONDS = TimeUnit.SECONDS.toMillis(10L);
    private final long invalidAfterTimeInMillis = System.currentTimeMillis() + TEN_SECONDS;
    private volatile Future<V> delegate;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate != null && this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate != null && this.delegate.isCancelled();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.delegate.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.get(timeout, unit);
    }

    @Override
    public boolean isDone() {
        return this.delegate != null ? this.delegate.isDone() : System.currentTimeMillis() >= this.invalidAfterTimeInMillis;
    }

    protected Future<V> delegate() {
        return this.delegate;
    }

    public void setDelegate(@Nullable Future<V> delegate) {
        this.delegate = delegate;
    }
}

