/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.codeinsights;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;

public abstract class AbstractInsightsBuilder
extends BuilderSupport {
    private static final List<String> SUPPORTED_URL_SCHEMES = ImmutableList.of((Object)"http", (Object)"https");
    private static final int MAX_URL_LENGTH = 2000;

    protected URI validate(URI url, String field) {
        if (url == null) {
            return null;
        }
        if (SUPPORTED_URL_SCHEMES.contains(url.getScheme())) {
            if (url.toString().length() > 2000) {
                throw new IllegalArgumentException(String.format("The URL '%s' must be less than %d characters in total", field, 2000));
            }
            return url;
        }
        throw new IllegalArgumentException(String.format("The URL '%s' can only be of protocol 'http' or 'https'", field));
    }
}

