/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.codeinsights.annotation;

import com.atlassian.bitbucket.codeinsights.annotation.SingleAddInsightAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.report.InsightReport;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;

public class BulkAddInsightAnnotationRequest {
    private final Collection<SingleAddInsightAnnotationRequest> annotationRequests;
    private final InsightReport report;

    private BulkAddInsightAnnotationRequest(Builder builder) {
        this.annotationRequests = builder.annotationRequests.build();
        this.report = builder.report;
    }

    public int getCount() {
        return this.annotationRequests.size();
    }

    @Nonnull
    public Collection<SingleAddInsightAnnotationRequest> getAnnotationRequests() {
        return this.annotationRequests;
    }

    @Nonnull
    public InsightReport getReport() {
        return this.report;
    }

    public static final class Builder
    extends BuilderSupport {
        private final ImmutableList.Builder<SingleAddInsightAnnotationRequest> annotationRequests;
        private final InsightReport report;

        public Builder(@Nonnull InsightReport report) {
            this.report = Objects.requireNonNull(report, "report");
            this.annotationRequests = ImmutableList.builder();
        }

        @Nonnull
        public Builder annotationRequest(@Nonnull SingleAddInsightAnnotationRequest value) {
            Builder.addIf(Objects::nonNull, this.annotationRequests, (Object)value);
            return this;
        }

        @Nonnull
        public Builder annotationRequests(@Nullable Iterable<SingleAddInsightAnnotationRequest> values) {
            Builder.addIf(Objects::nonNull, this.annotationRequests, values);
            return this;
        }

        @Nonnull
        public BulkAddInsightAnnotationRequest build() {
            return new BulkAddInsightAnnotationRequest(this);
        }
    }
}

