/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.codeinsights.annotation;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

public class DeleteAnnotationRequest {
    private final String reportKey;
    private final String commitId;
    private final Set<String> externalIds;
    private final Repository repository;

    private DeleteAnnotationRequest(@Nonnull Builder builder) {
        this.reportKey = builder.reportKey;
        this.commitId = builder.commitId;
        this.externalIds = builder.externalIds.build();
        this.repository = builder.repository;
    }

    @Nonnull
    public String getReportKey() {
        return this.reportKey;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public Set<String> getExternalIds() {
        return this.externalIds;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static class Builder
    extends BuilderSupport {
        private final String reportKey;
        private final String commitId;
        private final ImmutableSet.Builder<String> externalIds;
        private final Repository repository;

        public Builder(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull String reportKey) {
            this.reportKey = Builder.requireNonBlank((String)reportKey, (String)"reportKey");
            this.commitId = Builder.requireNonBlank((String)commitId, (String)"commitId");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.externalIds = ImmutableSet.builder();
        }

        @Nonnull
        public DeleteAnnotationRequest build() {
            return new DeleteAnnotationRequest(this);
        }

        @Nonnull
        public Builder externalId(@Nonnull String value) {
            Builder.addIf(Objects::nonNull, this.externalIds, (Object)value);
            return this;
        }

        @Nonnull
        public Builder externalIds(@Nonnull Iterable<String> values) {
            Builder.addIf(Objects::nonNull, this.externalIds, values);
            return this;
        }
    }
}

