/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.codeinsights.event;

import com.atlassian.bitbucket.codeinsights.report.InsightDataType;
import com.atlassian.bitbucket.codeinsights.report.InsightReport;
import com.atlassian.bitbucket.codeinsights.report.InsightReportData;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.hash.Hashing;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

@TransactionAware
public abstract class CodeInsightsDetailedReportEvent
extends RepositoryEvent {
    private final Map<String, Long> countByType;
    private final String detailsHash;
    private final String linkHash;
    private final String logoHash;
    private final String reporterHash;
    private final String result;

    public CodeInsightsDetailedReportEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull InsightReport report) {
        super(source, repository);
        this.countByType = report.getData().stream().collect(Collectors.groupingBy(data -> CodeInsightsDetailedReportEvent.getComputedType(data), Collectors.counting()));
        this.detailsHash = report.getDetails().map(this::toUUID).orElse(null);
        this.linkHash = report.getLink().map(URI::toString).map(this::toUUID).orElse(null);
        this.logoHash = report.getLogoUrl().map(URI::toString).map(this::toUUID).orElse(null);
        this.reporterHash = report.getReporter().map(this::toUUID).orElse(null);
        this.result = report.getResult().map(Enum::name).orElse(null);
    }

    @Nonnull
    public Map<String, Long> getDataCounts() {
        return this.countByType;
    }

    @Nullable
    public String getDetails() {
        return this.detailsHash;
    }

    @Nullable
    public String getLink() {
        return this.linkHash;
    }

    @Nullable
    public String getLogo() {
        return this.logoHash;
    }

    @Nullable
    public String getReporter() {
        return this.reporterHash;
    }

    @Nullable
    public String getResult() {
        return this.result;
    }

    private static String getComputedType(InsightReportData data) {
        if (data.getType() != null) {
            return data.getType().name();
        }
        if (data.getValue() instanceof String) {
            return InsightDataType.TEXT.name();
        }
        if (data.getValue() instanceof Boolean) {
            return InsightDataType.BOOLEAN.name();
        }
        if (data.getValue() instanceof Number) {
            return InsightDataType.NUMBER.name();
        }
        return "UNKNOWN";
    }

    private String toUUID(String input) {
        return UUID.nameUUIDFromBytes(Hashing.sha256().hashString((CharSequence)input, StandardCharsets.UTF_8).asBytes()).toString();
    }
}

