/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.codeinsights.report;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractInsightReportRequest {
    private final String commitId;
    private final PullRequest pullRequest;
    private final Repository repository;

    protected AbstractInsightReportRequest(AbstractBuilder builder) {
        this.commitId = builder.commitId;
        this.pullRequest = builder.pullRequest;
        this.repository = builder.repository;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public Optional<PullRequest> getPullRequest() {
        return Optional.ofNullable(this.pullRequest);
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
        private final String commitId;
        private final Repository repository;
        private PullRequest pullRequest;

        public AbstractBuilder(@Nonnull PullRequest pullRequest) {
            this(Objects.requireNonNull(pullRequest, "pullRequest").getToRef().getRepository(), pullRequest.getFromRef().getLatestCommit());
            this.pullRequest = pullRequest;
        }

        public AbstractBuilder(@Nonnull Repository repository, @Nonnull String commitId) {
            this.commitId = Objects.requireNonNull(commitId, "commitId");
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        @Nonnull
        protected abstract T self();
    }
}

