/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.codeinsights.report;

import com.atlassian.bitbucket.codeinsights.report.InsightDataType;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class InsightReportData {
    private final InsightDataType type;
    private final String title;
    private final Object value;

    private InsightReportData() {
        this.type = null;
        this.title = null;
        this.value = null;
    }

    private InsightReportData(Builder builder) {
        this.type = builder.type;
        this.title = builder.title;
        this.value = builder.value;
    }

    @Nullable
    public InsightDataType getType() {
        return this.type;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public Object getValue() {
        return this.value;
    }

    public static class Builder
    extends BuilderSupport {
        private final String title;
        private final Object value;
        private InsightDataType type;

        public Builder(@Nonnull String title, @Nonnull Object value) {
            this.title = Builder.requireNonBlank((String)title, (String)"title");
            this.value = Objects.requireNonNull(value, "value");
        }

        @Nonnull
        public InsightReportData build() {
            return new InsightReportData(this);
        }

        @Nonnull
        public Builder type(@Nonnull InsightDataType value) {
            this.type = Objects.requireNonNull(value, "type");
            return this;
        }
    }
}

