/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.codeinsights.report;

import com.atlassian.bitbucket.codeinsights.AbstractInsightsBuilder;
import com.atlassian.bitbucket.codeinsights.report.InsightReportData;
import com.atlassian.bitbucket.codeinsights.report.InsightResult;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.ShaUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.List;
import java.util.Objects;

public class SetInsightReportRequest {
    private final String commitId;
    private final String coverageProviderKey;
    private final List<InsightReportData> data;
    private final String details;
    private final String key;
    private final URI link;
    private final URI logoUrl;
    private final Repository repository;
    private final InsightResult result;
    private final String title;
    private final String reporter;

    private SetInsightReportRequest(Builder builder) {
        this.commitId = builder.commitId;
        this.coverageProviderKey = builder.coverageProviderKey;
        this.data = builder.data.build();
        this.details = builder.details;
        this.key = builder.key;
        this.link = builder.link;
        this.logoUrl = builder.logoUrl;
        this.repository = builder.repository;
        this.result = builder.result;
        this.title = builder.title;
        this.reporter = builder.reporter;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nullable
    public String getCoverageProviderKey() {
        return this.coverageProviderKey;
    }

    @Nonnull
    public List<InsightReportData> getData() {
        return this.data;
    }

    @Nullable
    public String getDetails() {
        return this.details;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nullable
    public URI getLink() {
        return this.link;
    }

    @Nullable
    public URI getLogoUrl() {
        return this.logoUrl;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public InsightResult getResult() {
        return this.result;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public String getReporter() {
        return this.reporter;
    }

    public static final class Builder
    extends AbstractInsightsBuilder {
        private final String commitId;
        private final ImmutableList.Builder<InsightReportData> data;
        private final String key;
        private final Repository repository;
        private final String title;
        private String coverageProviderKey;
        private String details;
        private URI link;
        private URI logoUrl;
        private InsightResult result;
        private String reporter;

        public Builder(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull String key, @Nonnull String title) {
            this.commitId = Builder.requireNonBlank((String)commitId, (String)"commitId");
            this.key = Builder.requireNonBlank((String)key, (String)"key");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.title = Builder.requireNonBlank((String)title, (String)"title");
            Preconditions.checkArgument((key.length() <= 450 ? 1 : 0) != 0, (Object)"key must be fewer than 450 characters");
            Preconditions.checkArgument((title.length() <= 450 ? 1 : 0) != 0, (Object)"title must be fewer than 450 characters");
            Preconditions.checkArgument((boolean)ShaUtils.isHash((String)commitId), (Object)"commitId must be a 40 character hexadecimal commit");
            this.data = ImmutableList.builder();
        }

        @Nonnull
        public SetInsightReportRequest build() {
            return new SetInsightReportRequest(this);
        }

        @Nonnull
        public Builder coverageProviderKey(@Nullable String value) {
            this.coverageProviderKey = value;
            return this;
        }

        @Nonnull
        public Builder data(@Nonnull List<InsightReportData> values) {
            Builder.addIf(Objects::nonNull, this.data, values);
            return this;
        }

        @Nonnull
        public Builder data(@Nonnull InsightReportData value) {
            Builder.addIf(Objects::nonNull, this.data, (Object)value);
            return this;
        }

        @Nonnull
        public Builder details(@Nullable String value) {
            this.details = value;
            return this;
        }

        @Nonnull
        public Builder link(@Nullable URI value) {
            this.link = this.validate(value, "link");
            return this;
        }

        @Nonnull
        public Builder logoUrl(@Nullable URI value) {
            this.logoUrl = this.validate(value, "logoUrl");
            return this;
        }

        @Nonnull
        public Builder result(@Nullable InsightResult value) {
            this.result = value;
            return this;
        }

        @Nonnull
        public Builder reporter(@Nullable String value) {
            Preconditions.checkArgument((this.reporter == null || this.reporter.length() <= 450 ? 1 : 0) != 0, (Object)"reporter must be fewer than 450 characters");
            this.reporter = value;
            return this;
        }
    }
}

