/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.linkaggregation.impl;

import com.atlassian.linkaggregation.RemoteLinkAggregateTimeModifiedService;
import com.atlassian.linkaggregation.RemoteLinkAggregation;
import com.atlassian.linkaggregation.RemoteLinkAggregator;
import com.atlassian.linkaggregation.impl.Iterables2;
import com.atlassian.linkaggregation.impl.RemoteLinkAggregationModel;
import com.atlassian.linkaggregation.impl.RemoteLinkAggregatorModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import jakarta.annotation.Nullable;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RemoteLinkAggregatorService {
    private static final int CHUNK_SIZE = 100;
    private final PluginAccessor pluginAccessor;

    public RemoteLinkAggregatorService(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public ZonedDateTime getLastModifiedZonedDate(final List<String> globalIds) {
        List enabledTimeModifiedServices = this.pluginAccessor.getEnabledModulesByClass(RemoteLinkAggregateTimeModifiedService.class);
        if (enabledTimeModifiedServices.isEmpty()) {
            return ZonedDateTime.now();
        }
        return (ZonedDateTime)Ordering.natural().max(Iterables.transform((Iterable)Iterables.filter((Iterable)enabledTimeModifiedServices, (Predicate)Predicates.notNull()), (Function)new Function<RemoteLinkAggregateTimeModifiedService, ZonedDateTime>(){

            public ZonedDateTime apply(@Nullable RemoteLinkAggregateTimeModifiedService timeModifiedService) {
                return timeModifiedService.getLastModifiedZonedDate(globalIds);
            }
        }));
    }

    public Iterable<RemoteLinkAggregationModel> aggregateLinksByGlobalId(List<String> globalIds) {
        List enabledMD = this.pluginAccessor.getEnabledModuleDescriptorsByClass(RemoteLinkAggregatorModuleDescriptor.class);
        return this.aggregateLinksByGlobalIdChunked(globalIds, (List<RemoteLinkAggregator>)ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)enabledMD, (Predicate)Predicates.notNull()), AbstractModuleDescriptor::getModule), (Predicate)Predicates.notNull())), 100);
    }

    @VisibleForTesting
    Iterable<RemoteLinkAggregationModel> aggregateLinksByGlobalIdChunked(Iterable<String> globalIds, final List<RemoteLinkAggregator> aggregators, int chunkSize) {
        return Iterables2.chunk(Iterables.filter(globalIds, (Predicate)Predicates.notNull()), new Function<Iterable<String>, Iterable<RemoteLinkAggregationModel>>(){

            public Iterable<RemoteLinkAggregationModel> apply(Iterable<String> input) {
                Map<String, Iterable<RemoteLinkAggregation>> aggregations = RemoteLinkAggregatorService.this.aggregateLinksByGlobalId(input, aggregators);
                return Iterables.transform(aggregations.entrySet(), (Function)new Function<Map.Entry<String, Iterable<RemoteLinkAggregation>>, RemoteLinkAggregationModel>(this){

                    public RemoteLinkAggregationModel apply(Map.Entry<String, Iterable<RemoteLinkAggregation>> input) {
                        return new RemoteLinkAggregationModel(input.getKey(), input.getValue());
                    }
                });
            }
        }, chunkSize);
    }

    private Map<String, Iterable<RemoteLinkAggregation>> aggregateLinksByGlobalId(Iterable<String> globalIds, List<RemoteLinkAggregator> aggregators) {
        List empty = Collections.emptyList();
        LinkedHashMap<String, Iterable<RemoteLinkAggregation>> map = new LinkedHashMap<String, Iterable<RemoteLinkAggregation>>();
        for (RemoteLinkAggregator aggregator : aggregators) {
            Map<String, Iterable<RemoteLinkAggregation>> results = aggregator.aggregateForGlobalIds(globalIds);
            for (String key : results.keySet()) {
                map.put(key, Iterables.concat((Iterable)((Iterable)MoreObjects.firstNonNull((Object)((Iterable)map.get(key)), empty)), (Iterable)((Iterable)MoreObjects.firstNonNull(results.get(key), empty))));
            }
        }
        return map;
    }
}

