/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.linkaggregation.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.linkaggregation.RemoteLinkAggregation;
import com.atlassian.linkaggregation.impl.RemoteLinkAggregationModel;
import com.atlassian.linkaggregation.impl.RemoteLinkAggregatorService;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="aggregation")
public class RemoteLinkAggregatorResource {
    private static final int MAX_GLOBAL_IDS = 1000;
    private final Logger log = LoggerFactory.getLogger(RemoteLinkAggregatorResource.class);
    private final RemoteLinkAggregatorService linkCountAggregatorService;
    private static final String READ_SCOPE = "READ";
    private static final String BITBUCKET_PUBLIC_REPOS_SCOPE = "PUBLIC_REPOS";

    @Inject
    public RemoteLinkAggregatorResource(RemoteLinkAggregatorService linkCountAggregatorService) {
        this.linkCountAggregatorService = linkCountAggregatorService;
    }

    @GET
    @Produces(value={"application/json"})
    @UnrestrictedAccess
    @ScopesAllowed(requiredScope={"READ", "PUBLIC_REPOS"})
    public Response getAggregateLinkCount(@QueryParam(value="globalId") List<String> globalIds, @Context Request request) {
        Response response = this.validateGlobalIds(globalIds);
        if (response != null) {
            return response;
        }
        ZonedDateTime lastModified = this.linkCountAggregatorService.getLastModifiedZonedDate(globalIds = globalIds.subList(0, Math.min(globalIds.size(), 1000)));
        Response.ResponseBuilder rb = request.evaluatePreconditions(Date.from(lastModified.toInstant()));
        if (rb != null) {
            return this.getResponseFromBuilder(lastModified, rb);
        }
        final Iterable<RemoteLinkAggregationModel> linkAggregation = this.linkCountAggregatorService.aggregateLinksByGlobalId(globalIds);
        StreamingOutput so = new StreamingOutput(){

            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                RemoteLinkAggregatorResource.this.outputLinkAggregationToStream(outputStream, linkAggregation);
            }
        };
        Response.ResponseBuilder ok = Response.ok((Object)so);
        return this.getResponseFromBuilder(lastModified, ok);
    }

    private Response getResponseFromBuilder(ZonedDateTime lastModified, Response.ResponseBuilder ok) {
        return ok.lastModified(Date.from(lastModified.toInstant())).cacheControl(CacheControl.valueOf((String)"max-age=0, must-revalidate")).build();
    }

    @VisibleForTesting
    protected void outputLinkAggregationToStream(OutputStream outputStream, Iterable<RemoteLinkAggregationModel> linkAggregation) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        objectMapper.configure(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM, false);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        JsonGenerator jsonGenerator = objectMapper.getJsonFactory().createJsonGenerator((Writer)writer);
        jsonGenerator.writeStartObject();
        jsonGenerator.writeFieldName("targets");
        jsonGenerator.writeStartObject();
        for (RemoteLinkAggregationModel aggregatesForGlobalId : linkAggregation) {
            String globalId = aggregatesForGlobalId.getGlobalId();
            jsonGenerator.writeFieldName(globalId);
            jsonGenerator.writeStartArray();
            String innerDelimiter = "";
            for (RemoteLinkAggregation remoteLinkAggregation : aggregatesForGlobalId.getLinkAggregation()) {
                jsonGenerator.flush();
                writer.write(innerDelimiter);
                innerDelimiter = ",";
                remoteLinkAggregation.write(writer);
            }
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeEndObject();
        jsonGenerator.writeEndObject();
        jsonGenerator.flush();
        ((Writer)writer).flush();
    }

    @VisibleForTesting
    Response validateGlobalIds(List<String> globalIds) {
        if (globalIds.isEmpty()) {
            return Response.ok((Object)ImmutableMap.of((Object)"targets", (Object)ImmutableMap.of())).build();
        }
        for (String globalId : globalIds) {
            if (!globalId.trim().isEmpty()) continue;
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid globalId - must not be blank").build();
        }
        return null;
    }
}

