/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.auth.HttpAuthenticationFailureContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessContext;
import com.atlassian.bitbucket.scm.AuthenticationState;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.FilterChain;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefaultHttpAuthenticationContext
implements HttpAuthenticationFailureContext,
HttpAuthenticationSuccessContext {
    private AuthenticationException authenticationException;
    private AuthenticationState authenticationState;
    private final FilterChain chain;
    private final Object credentials;
    private final String authenticationMethod;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private ApplicationUser user;
    private final String username;

    public DefaultHttpAuthenticationContext(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain chain, @Nonnull String method, @Nullable String username, @Nullable Object credentials) {
        this.authenticationMethod = Objects.requireNonNull(method, "authenticationMethod");
        this.authenticationState = AuthenticationState.NOT_AUTHENTICATED;
        this.chain = Objects.requireNonNull(chain, "filterChain");
        this.request = Objects.requireNonNull(request, "request");
        this.response = Objects.requireNonNull(response, "response");
        this.username = username;
        this.credentials = credentials;
    }

    @Nonnull
    public AuthenticationState getAuthenticationState() {
        return this.authenticationState;
    }

    @Nonnull
    public AuthenticationException getAuthenticationException() {
        return this.authenticationException;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    @Nonnull
    public FilterChain getFilterChain() {
        return this.chain;
    }

    @Nonnull
    public String getMethod() {
        return this.authenticationMethod;
    }

    @Nonnull
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Nonnull
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Nonnull
    public ApplicationUser getUser() {
        return this.user;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAuthenticated() {
        return this.authenticationState == AuthenticationState.AUTHENTICATED;
    }

    public String toString() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.username, (CharSequence)"<>");
    }

    public void onFailure(@Nonnull AuthenticationState authenticationState, AuthenticationException exception) {
        this.authenticationException = exception;
        this.authenticationState = Objects.requireNonNull(authenticationState, "authenticationState");
    }

    public void onSuccess(ApplicationUser newUser) {
        HttpSession session;
        if (this.user != null && newUser != null && !this.user.equals((Object)newUser) && (session = this.request.getSession(false)) != null) {
            session.invalidate();
        }
        this.user = newUser;
        this.authenticationState = AuthenticationState.AUTHENTICATED;
    }

    public void setAuthenticationState(AuthenticationState authenticationState) {
        this.authenticationState = authenticationState;
    }

    public void setUser(ApplicationUser user) {
        this.user = user;
    }
}

