/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessContext;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;

public class HttpAuthUtils {
    public static final String AUTH_PREFIX_BASIC = "Basic ";
    public static final String AUTH_PREFIX_BEARER = "Bearer ";
    public static final String HEADER_AUTHORIZATION = "Authorization";

    private HttpAuthUtils() {
    }

    @Nullable
    public static String getBasicAuthHeaderValue(@Nonnull HttpServletRequest request) {
        if (!HttpAuthUtils.hasBasicAuthHeader(request)) {
            return null;
        }
        return request.getHeader(HEADER_AUTHORIZATION).substring(AUTH_PREFIX_BASIC.length());
    }

    @Nullable
    public static String getBearerAuthHeaderValue(@Nonnull HttpServletRequest request) {
        if (!HttpAuthUtils.hasBearerAuthHeader(request)) {
            return null;
        }
        return request.getHeader(HEADER_AUTHORIZATION).substring(AUTH_PREFIX_BEARER.length());
    }

    public static boolean hasBasicAuthHeader(@Nonnull HttpServletRequest request) {
        String authorization = request.getHeader(HEADER_AUTHORIZATION);
        return authorization != null && authorization.startsWith(AUTH_PREFIX_BASIC);
    }

    public static boolean hasBearerAuthHeader(HttpServletRequest request) {
        String authorization = request.getHeader(HEADER_AUTHORIZATION);
        return authorization != null && authorization.startsWith(AUTH_PREFIX_BEARER);
    }

    public static boolean isBasicAuth(@Nonnull HttpAuthenticationSuccessContext context) {
        return "basic".equals(context.getMethod());
    }

    public static boolean isGitLfsScmCall(HttpAuthenticationSuccessContext context) {
        return HttpAuthUtils.isGitLfsScmCall(context.getRequest());
    }

    public static boolean isGitLfsScmCall(HttpServletRequest request) {
        return "/scm".equals(request.getServletPath()) && (request.getRequestURI().endsWith("info/lfs/objects/batch") || request.getRequestURI().endsWith("info/lfs/locks"));
    }

    public static boolean isRestCall(@Nonnull HttpAuthenticationSuccessContext context) {
        return HttpAuthUtils.isRestCall(context.getRequest());
    }

    public static boolean isRestCall(@Nonnull HttpServletRequest request) {
        String relativeUrl = request.getRequestURI().substring(request.getContextPath().length());
        return relativeUrl.startsWith("/rest/") || relativeUrl.equals("/status");
    }
}

