/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Set;

public class DeprecateConfigurationRequest {
    private final String deprecationMessage;
    private final Set<String> properties;

    private DeprecateConfigurationRequest(String deprecationMessage, Set<String> properties) {
        this.deprecationMessage = deprecationMessage;
        this.properties = properties;
    }

    @Nonnull
    public String getDeprecationMessage() {
        return this.deprecationMessage;
    }

    @Nonnull
    public Set<String> getProperties() {
        return this.properties;
    }

    public static class Builder
    extends BuilderSupport {
        private final String deprecationMessage;
        private final ImmutableSet.Builder<String> properties;

        public Builder(@Nonnull String deprecationMessage) {
            this.deprecationMessage = "# " + Builder.requireNonBlank((String)deprecationMessage, (String)"deprecationMessage");
            this.properties = ImmutableSet.builder();
        }

        @Nonnull
        public DeprecateConfigurationRequest build() {
            return new DeprecateConfigurationRequest(this.deprecationMessage, (Set<String>)this.properties.build());
        }

        @Nonnull
        public Builder property(@Nonnull String value) {
            this.properties.add((Object)Builder.requireNonBlank((String)value, (String)"property"));
            return this;
        }
    }
}

