/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.bitbucket.comment.CommentThread;
import com.atlassian.bitbucket.content.AbstractDiffContentCallback;
import com.atlassian.bitbucket.content.ConflictMarker;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContentFilter;
import com.atlassian.bitbucket.content.DiffContext;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.content.DiffSummary;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.util.Operation;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.stream.Stream;

public class DiffContentCallbackFilter
extends AbstractDiffContentCallback {
    private final DiffContentCallback callback;
    private final DiffContentFilter filter;
    private String context;
    private Operation<Void, IOException> diffOp;
    private int dstLine;
    private int srcLine;
    private DiffSegmentType segmentType;

    public DiffContentCallbackFilter(DiffContentCallback callback, DiffContentFilter filter) {
        this.callback = callback;
        this.filter = filter;
    }

    public static DiffContentCallback filter(@Nonnull DiffContentCallback callback, DiffContentFilter filter) {
        return filter == null ? callback : new DiffContentCallbackFilter(callback, filter);
    }

    public void offerThreads(@Nonnull Stream<CommentThread> threads) throws IOException {
        this.callback.offerThreads(threads);
    }

    public void onBinary(Path src, Path dst) throws IOException {
    }

    public void onDiffStart(Path src, Path dst) throws IOException {
        this.diffOp = () -> {
            this.callback.onDiffStart(src, dst);
            return null;
        };
    }

    public void onDiffEnd(boolean truncated) throws IOException {
        if (this.diffOp == null) {
            this.callback.onDiffEnd(truncated);
        }
    }

    public void onEnd(@Nonnull DiffSummary summary) throws IOException {
        this.callback.onEnd(summary);
    }

    public void onHunkStart(int srcLine, int srcSpan, int dstLine, int dstSpan, String context) throws IOException {
        this.context = context;
        this.dstLine = dstLine;
        this.srcLine = srcLine;
    }

    public void onHunkEnd(boolean truncated) throws IOException {
    }

    public void onSegmentStart(@Nonnull DiffSegmentType type) throws IOException {
        this.segmentType = type;
    }

    public void onSegmentEnd(boolean truncated) throws IOException {
    }

    public void onSegmentLine(@Nonnull String line, ConflictMarker marker, boolean truncated) throws IOException {
        if (this.filter.apply(line)) {
            if (this.diffOp != null) {
                this.diffOp.perform();
                this.diffOp = null;
            }
            this.callback.onHunkStart(this.srcLine, this.segmentType == DiffSegmentType.ADDED ? 0 : 1, this.dstLine, this.segmentType == DiffSegmentType.REMOVED ? 0 : 1, this.context);
            this.callback.onSegmentStart(this.segmentType);
            this.callback.onSegmentLine(line, marker, truncated);
            this.callback.onSegmentEnd(false);
            this.callback.onHunkEnd(false);
        }
        if (this.segmentType != DiffSegmentType.ADDED) {
            ++this.srcLine;
        }
        if (this.segmentType != DiffSegmentType.REMOVED) {
            ++this.dstLine;
        }
    }

    public void onStart(@Nonnull DiffContext context) throws IOException {
        this.callback.onStart(context);
    }
}

