/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class CrowdUserSearchRequest {
    private final Long directoryId;
    private final Long lastActiveAfter;
    private final Long lastActiveBefore;
    private final String userFilterText;

    public CrowdUserSearchRequest(Builder builder) {
        this.directoryId = builder.directoryId;
        this.lastActiveAfter = builder.lastActiveAfter;
        this.lastActiveBefore = builder.lastActiveBefore;
        this.userFilterText = builder.userFilterText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrowdUserSearchRequest that = (CrowdUserSearchRequest)o;
        return Objects.equals(this.directoryId, that.directoryId) && Objects.equals(this.lastActiveAfter, that.lastActiveAfter) && Objects.equals(this.lastActiveBefore, that.lastActiveBefore) && Objects.equals(this.userFilterText, that.userFilterText);
    }

    @Nonnull
    public Optional<Long> getDirectoryId() {
        return Optional.ofNullable(this.directoryId);
    }

    @Nonnull
    public Optional<Long> getLastActiveAfter() {
        return Optional.ofNullable(this.lastActiveAfter);
    }

    @Nonnull
    public Optional<Long> getLastActiveBefore() {
        return Optional.ofNullable(this.lastActiveBefore);
    }

    @Nonnull
    public Optional<String> getUserFilterText() {
        return Optional.ofNullable(this.userFilterText);
    }

    public int hashCode() {
        return Objects.hash(this.directoryId, this.lastActiveAfter, this.lastActiveBefore, this.userFilterText);
    }

    public static class Builder {
        private Long directoryId;
        private Long lastActiveAfter;
        private Long lastActiveBefore;
        private String userFilterText;

        @Nonnull
        public CrowdUserSearchRequest build() {
            return new CrowdUserSearchRequest(this);
        }

        @Nonnull
        public Builder directoryId(@Nullable Long value) {
            this.directoryId = value;
            return this;
        }

        @Nonnull
        public Builder lastActiveAfter(@Nullable Long value) {
            this.lastActiveAfter = value;
            return this;
        }

        @Nonnull
        public Builder lastActiveBefore(@Nullable Long value) {
            this.lastActiveBefore = value;
            return this;
        }

        @Nonnull
        public Builder userFilterText(@Nullable String value) {
            this.userFilterText = StringUtils.stripToNull((String)value);
            return this;
        }
    }
}

