/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.date;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum DateType {
    ABSOLUTE(1L),
    RELATIVE(0L);

    private final long id;

    private DateType(long id) {
        this.id = id;
    }

    @Nonnull
    public static Optional<DateType> fromId(long id) {
        return Arrays.stream(DateType.values()).filter(value -> value.id == id).findAny();
    }

    @Nonnull
    public static Optional<DateType> fromString(@Nonnull String str) {
        Objects.requireNonNull(str, "str");
        return Arrays.stream(DateType.values()).filter(value -> value.toString().equalsIgnoreCase(str)).findAny();
    }

    public long getId() {
        return this.id;
    }
}

