/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.stash.internal.db.DbType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;

public class DbTypeBean {
    public static final DbTypeBean DEFAULT = new DbTypeBean(DbType.POSTGRES);
    public static final List<DbTypeBean> ALL = ImmutableList.copyOf((Collection)Lists.transform((List)DbType.AS_LIST, DbTypeBean::new));
    private final DbType adaptee;

    private DbTypeBean(DbType adaptee) {
        this.adaptee = adaptee;
    }

    @Nullable
    public static DbTypeBean forKey(@Nonnull String key) {
        return DbType.forKey((String)key).map(DbTypeBean::new).orElse(null);
    }

    @Nonnull
    public String generateUrl(String hostName, String databaseNameOrSid, int port) {
        return this.adaptee.generateUrl(hostName, databaseNameOrSid, port);
    }

    @Nonnull
    public String getDefaultPort() {
        return String.valueOf(this.adaptee.getDefaultPort());
    }

    @Nonnull
    public String getDisplayNameKey() {
        return this.adaptee.getDisplayNameKey();
    }

    @Nonnull
    public String getDriverClassName() {
        return this.adaptee.getDriverClassName();
    }

    @Nonnull
    public String getKey() {
        return this.adaptee.getKey();
    }

    @Nonnull
    public String getHelpKey() {
        return this.adaptee.getHelpKey();
    }

    @Nonnull
    public String getProtocol() {
        return this.adaptee.getProtocol();
    }

    public boolean getUsesSid() {
        return this.adaptee.usesSid();
    }

    public boolean isDriverAvailable() {
        return this.adaptee.isDriverAvailable();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbTypeBean)) {
            return false;
        }
        DbTypeBean other = (DbTypeBean)o;
        return this.adaptee.equals((Object)other.adaptee);
    }

    public int hashCode() {
        return this.adaptee.hashCode();
    }

    public String toString() {
        return this.adaptee.toString();
    }
}

