/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.integrity;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;

public class PullRequestIntegrityCheckRequest {
    private final Long activityWindowMs;
    private final String hierarchyId;

    protected PullRequestIntegrityCheckRequest(Builder builder) {
        this.hierarchyId = builder.hierarchyId;
        this.activityWindowMs = builder.stateChangeWindowMs;
    }

    @Nonnull
    public OptionalLong getActivityWindow(@Nonnull TimeUnit unit) {
        return this.activityWindowMs == null ? OptionalLong.empty() : OptionalLong.of(Objects.requireNonNull(unit, "unit").convert(this.activityWindowMs, TimeUnit.MILLISECONDS));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PullRequestIntegrityCheckRequest that = (PullRequestIntegrityCheckRequest)o;
        return com.google.common.base.Objects.equal((Object)this.activityWindowMs, (Object)that.activityWindowMs) && com.google.common.base.Objects.equal((Object)this.hierarchyId, (Object)that.hierarchyId);
    }

    @Nonnull
    public Optional<String> getHierarchyId() {
        return Optional.ofNullable(this.hierarchyId);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.activityWindowMs, this.hierarchyId});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("activityWindowMs", (Object)this.activityWindowMs).add("hierarchyId", (Object)this.hierarchyId).toString();
    }

    public static class Builder
    extends BuilderSupport {
        private String hierarchyId;
        private Long stateChangeWindowMs;

        @Nonnull
        public Builder activityWindow(long duration, @Nonnull TimeUnit unit) {
            Objects.requireNonNull(unit, "unit");
            this.stateChangeWindowMs = TimeUnit.MILLISECONDS.convert(duration, unit);
            return this;
        }

        @Nonnull
        public PullRequestIntegrityCheckRequest build() {
            return new PullRequestIntegrityCheckRequest(this);
        }

        @Nonnull
        public Builder hierarchyId(String value) {
            this.hierarchyId = value;
            return this;
        }
    }
}

