/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.language;

import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.Objects;

public class Language
implements Comparable<Language> {
    private final Locale locale;

    public Language(@Nonnull Locale locale) {
        this.locale = Objects.requireNonNull(locale, "locale");
    }

    @Nonnull
    public Locale getLocale() {
        return this.locale;
    }

    public String getLocalizedName() {
        return this.locale.getDisplayName(this.locale);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Language language = (Language)o;
        return this.locale.equals(language.locale);
    }

    public int hashCode() {
        return this.locale.hashCode();
    }

    @Override
    public int compareTo(@Nonnull Language other) {
        return this.locale.toString().compareTo(other.locale.toString());
    }
}

