/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.stash.internal.mesh.MeshRepositoriesMxBean;
import com.google.common.base.Suppliers;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class MeshRepositoriesMxBeanAdapter
implements MeshRepositoriesMxBean {
    private final long criticalThreshold;
    private final Supplier<Map<Integer, Long>> inconsistentReplicasByRepository;

    public MeshRepositoriesMxBeanAdapter(@Nonnull DmzMeshService meshService) {
        Objects.requireNonNull(meshService, "meshService");
        this.criticalThreshold = (long)Math.ceil((double)meshService.getReplicationFactor() / 2.0);
        this.inconsistentReplicasByRepository = Suppliers.memoizeWithExpiration(() -> ((DmzMeshService)meshService).getInconsistentRepositoryReplicaSummary(), (long)2L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Override
    public long getCriticalCount() {
        return this.inconsistentReplicasByRepository.get().values().stream().filter(inconsistentCount -> inconsistentCount >= this.criticalThreshold).count();
    }

    @Override
    public long getDegradedCount() {
        return this.inconsistentReplicasByRepository.get().values().stream().filter(inconsistentCount -> inconsistentCount < this.criticalThreshold).count();
    }

    @Override
    public long getTotalInconsistentReplicaCount() {
        return this.inconsistentReplicasByRepository.get().values().stream().mapToLong(Long::longValue).sum();
    }
}

