/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.ReplicaState;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

public class MeshRepositoryReplicaObservation {
    private final boolean force;
    private final Set<Long> nodeIds;
    private final String repositoryId;
    private final ReplicaState state;
    private final long version;

    private MeshRepositoryReplicaObservation(Builder builder) {
        this.force = builder.force;
        this.nodeIds = builder.nodeIds.build();
        this.repositoryId = builder.repositoryId;
        this.state = builder.state;
        this.version = builder.version;
    }

    @Nonnull
    public Set<Long> getNodeIds() {
        return this.nodeIds;
    }

    @Nonnull
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Nonnull
    public ReplicaState getState() {
        return this.state;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean isForce() {
        return this.force;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<Long> nodeIds;
        private final String repositoryId;
        private boolean force;
        private ReplicaState state;
        private Long version;

        public Builder(@Nonnull String repositoryId) {
            this.repositoryId = Builder.requireNonBlank((String)repositoryId, (String)"repositoryId");
            this.nodeIds = ImmutableSet.builder();
        }

        @Nonnull
        public MeshRepositoryReplicaObservation build() {
            if (this.state == null) {
                throw new IllegalStateException("A state must be set");
            }
            if (this.version == null || this.version < 0L) {
                throw new IllegalStateException("A version must be set");
            }
            return new MeshRepositoryReplicaObservation(this);
        }

        @Nonnull
        public Builder force(boolean value) {
            this.force = value;
            return this;
        }

        @Nonnull
        public Builder nodeId(long value) {
            this.nodeIds.add((Object)value);
            return this;
        }

        @Nonnull
        public Builder nodeIds(@Nonnull Iterable<Long> values) {
            Builder.addIf(Objects::nonNull, this.nodeIds, values);
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull ReplicaState value) {
            this.state = Objects.requireNonNull(value, "state");
            return this;
        }

        @Nonnull
        public Builder version(long value) {
            this.version = value;
            return this;
        }
    }
}

