/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.stash.internal.mesh.RemoteDataStoreShard;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

public class RemoteDataStore {
    private final List<RemoteDataStoreShard> shards;
    private final Type type;

    private RemoteDataStore(Builder builder) {
        this.type = builder.type;
        this.shards = builder.shards.build();
    }

    @Nonnull
    public List<RemoteDataStoreShard> getShards() {
        return this.shards;
    }

    @Nonnull
    public Type getType() {
        return this.type;
    }

    public static class Builder {
        private final ImmutableList.Builder<RemoteDataStoreShard> shards = new ImmutableList.Builder();
        private final Type type;

        public Builder(@Nonnull Type type) {
            this.type = Objects.requireNonNull(type, "type");
        }

        @Nonnull
        public RemoteDataStore build() {
            return new RemoteDataStore(this);
        }

        @Nonnull
        public Builder shards(@Nonnull List<RemoteDataStoreShard> value) {
            this.shards.addAll((Iterable)Objects.requireNonNull(value, "shards"));
            return this;
        }
    }

    public static enum Type {
        MANAGED,
        BITBUCKET,
        PATH,
        UNKNOWN;

    }
}

