/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class RemoteDataStoreShard {
    private final Set<Integer> partitions;
    private final long usableSpace;

    private RemoteDataStoreShard(Builder builder) {
        this.partitions = builder.partitions.build();
        this.usableSpace = builder.usableSpace;
    }

    @Nonnull
    public Set<Integer> getPartitions() {
        return this.partitions;
    }

    public long getUsableSpace() {
        return this.usableSpace;
    }

    public static class Builder {
        private final ImmutableSet.Builder<Integer> partitions;
        private final long usableSpace;

        public Builder(long usableSpace) {
            this.usableSpace = usableSpace;
            this.partitions = new ImmutableSet.Builder();
        }

        @Nonnull
        public RemoteDataStoreShard build() {
            return new RemoteDataStoreShard(this);
        }

        @Nonnull
        public Builder partitions(@Nonnull List<Integer> value) {
            this.partitions.addAll((Iterable)Objects.requireNonNull(value, "partitions"));
            return this;
        }
    }
}

