/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import jakarta.annotation.Nonnull;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class FilePermissionUtils {
    private static final BiMap<Integer, PosixFilePermission> INT_MODE_TO_POSIX_PERMISSION_MAP = ImmutableBiMap.builder().put((Object)1, (Object)PosixFilePermission.OTHERS_EXECUTE).put((Object)8, (Object)PosixFilePermission.GROUP_EXECUTE).put((Object)64, (Object)PosixFilePermission.OWNER_EXECUTE).put((Object)2, (Object)PosixFilePermission.OTHERS_WRITE).put((Object)16, (Object)PosixFilePermission.GROUP_WRITE).put((Object)128, (Object)PosixFilePermission.OWNER_WRITE).put((Object)4, (Object)PosixFilePermission.OTHERS_READ).put((Object)32, (Object)PosixFilePermission.GROUP_READ).put((Object)256, (Object)PosixFilePermission.OWNER_READ).build();
    private static final Map<PosixFilePermission, Integer> POSIX_PERMISSION_TO_INT_MODE_MAP = INT_MODE_TO_POSIX_PERMISSION_MAP.inverse();

    private FilePermissionUtils() {
        throw new UnsupportedOperationException("Cannot be initialised.");
    }

    public static int toIntMode(@Nonnull Set<PosixFilePermission> permissions, int baseMode) {
        return Objects.requireNonNull(permissions, "permissions").stream().map(POSIX_PERMISSION_TO_INT_MODE_MAP::get).reduce(baseMode, (first, second) -> first | second);
    }

    @Nonnull
    public static Set<PosixFilePermission> toPosixFilePermissions(int mode) {
        return (Set)INT_MODE_TO_POSIX_PERMISSION_MAP.entrySet().stream().filter(entry -> (mode & (Integer)entry.getKey()) > 0).map(Map.Entry::getValue).collect(MoreCollectors.toImmutableSet());
    }
}

