/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.io.IoConsumer;
import com.google.common.base.Charsets;
import com.google.common.math.IntMath;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileWalkerUtils {
    private static final Logger log = LoggerFactory.getLogger(FileWalkerUtils.class);

    private FileWalkerUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static Path walkFileTreeWithRetry(@Nonnull Path start, @Nonnull Set<FileVisitOption> options, int maxDepth, @Nonnull FileVisitor<Path> visitor, int retries) throws IOException {
        return FileWalkerUtils.walkFileTreeWithRetry(start, options, maxDepth, visitor, retries, 2000L, TimeUnit.SECONDS.toMillis(512L));
    }

    public static Path walkFileTreeWithRetry(@Nonnull Path start, @Nonnull Set<FileVisitOption> options, int maxDepth, @Nonnull FileVisitor<Path> visitor, int attempts, long initialDelay, long maximumDelay) throws IOException {
        return FileWalkerUtils.walkFileTreeWithRetry(start, options, maxDepth, visitor, attempts, initialDelay, maximumDelay, (IoConsumer<IOException>)((IoConsumer)e -> {}));
    }

    public static Path walkFileTreeWithRetry(@Nonnull Path start, @Nonnull Set<FileVisitOption> options, int maxDepth, @Nonnull FileVisitor<Path> visitor, int attempts, long initialDelay, long maximumDelay, IoConsumer<IOException> exceptionHandler) throws IOException {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(options, "options");
        Objects.requireNonNull(visitor, "visitor");
        if (attempts < 1) {
            throw new IllegalArgumentException("Need to attempt the file walk at least once");
        }
        IOException ex = null;
        TrackingFileVisitor fileVisitor = attempts > 1 ? new TrackingFileVisitor(start, visitor) : visitor;
        for (int i = 0; i < attempts; ++i) {
            try {
                return Files.walkFileTree(start, options, maxDepth, fileVisitor);
            }
            catch (IOException e) {
                try {
                    exceptionHandler.accept((Object)e);
                }
                catch (Exception exceptionHandlerEx) {
                    exceptionHandlerEx.addSuppressed(e);
                    log.debug("Exception encountered traversing {} and exceptionHandler threw exception", new Object[]{start, exceptionHandlerEx, exceptionHandlerEx});
                    throw exceptionHandlerEx;
                }
                long delay = Math.min(initialDelay * (long)IntMath.pow((int)2, (int)i), maximumDelay);
                log.warn("Exception encountered traversing {} attempt # {}/{} waiting {} seconds", new Object[]{start, i + 1, attempts, TimeUnit.MILLISECONDS.toSeconds(delay), log.isDebugEnabled() ? e : null});
                ex = e;
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    log.debug("Interrupted while waiting to retry file walk");
                }
                continue;
            }
        }
        log.error("Exception encountered traversing '{}' and all retries failed", (Object)start, ex);
        throw ex;
    }

    public static Path walkFileTreeWithRetry(@Nonnull Path start, @Nonnull FileVisitor<Path> visitor, int retries, long initialDelay, long maximumDelay) throws IOException {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(visitor, "visitor");
        return FileWalkerUtils.walkFileTreeWithRetry(start, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, visitor, retries, initialDelay, maximumDelay);
    }

    public static Path walkFileTreeWithRetry(@Nonnull Path start, @Nonnull FileVisitor<Path> visitor, int retries) throws IOException {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(visitor, "visitor");
        return FileWalkerUtils.walkFileTreeWithRetry(start, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, visitor, retries);
    }

    @NotThreadSafe
    static class TrackingFileVisitor
    implements FileVisitor<Path> {
        private final Path start;
        private final FileVisitor<Path> delegate;
        private final MessageDigest digest;
        private final Set<String> visited = new HashSet<String>();

        TrackingFileVisitor(Path start, @Nonnull FileVisitor<Path> delegate) {
            this.start = start;
            this.delegate = Objects.requireNonNull(delegate, "delegate");
            try {
                this.digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public FileVisitResult postVisitDirectory(@Nonnull Path dir, @Nonnull IOException exc) throws IOException {
            return this.delegate.postVisitDirectory(dir, exc);
        }

        @Override
        public FileVisitResult preVisitDirectory(@Nonnull Path dir, @Nonnull BasicFileAttributes attrs) throws IOException {
            return this.delegate.preVisitDirectory(dir, attrs);
        }

        @Override
        public FileVisitResult visitFile(@Nonnull Path file, @Nonnull BasicFileAttributes attrs) throws IOException {
            String hash = this.hashPath(file);
            if (this.visited.contains(hash)) {
                log.trace("walkFileTreeWithRetry('{}'): Skipping already visited file '{}'.", (Object)this.start, (Object)file);
                return FileVisitResult.CONTINUE;
            }
            FileVisitResult result = this.delegate.visitFile(file, attrs);
            this.visited.add(hash);
            return result;
        }

        @Override
        public FileVisitResult visitFileFailed(@Nonnull Path file, @Nonnull IOException exc) throws IOException {
            this.visited.remove(this.hashPath(file));
            return this.delegate.visitFileFailed(file, exc);
        }

        private String hashPath(Path path) {
            return new String(this.digest.digest(path.toString().getBytes()), Charsets.UTF_8);
        }
    }
}

