/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;

public class MigrationJobProgressUpdateRequest {
    private final KeyedMessage message;
    private final Integer percentage;

    private MigrationJobProgressUpdateRequest(@Nonnull Builder builder) {
        this.percentage = builder.percentage;
        this.message = builder.message;
    }

    @Nonnull
    public Optional<KeyedMessage> getMessage() {
        return Optional.ofNullable(this.message);
    }

    @Nonnull
    public Optional<Integer> getPercentage() {
        return Optional.ofNullable(this.percentage);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("message", this.message == null ? null : this.message.getRootMessage()).add("percentage", (Object)this.percentage).toString();
    }

    public static class Builder {
        private KeyedMessage message;
        private Integer percentage;

        @Nonnull
        public MigrationJobProgressUpdateRequest build() {
            return new MigrationJobProgressUpdateRequest(this);
        }

        @Nonnull
        public Builder message(@Nullable KeyedMessage value) {
            this.message = value;
            return this;
        }

        @Nonnull
        public Builder percentage(int value) {
            this.percentage = value;
            return this;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("message", this.message == null ? null : this.message.getRootMessage()).add("percentage", (Object)this.percentage).toString();
        }
    }
}

