/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.oauth2;

import com.atlassian.oauth2.client.api.ClientToken;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenEntity;
import com.atlassian.stash.internal.oauth2.OAuth2Exception;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;

public interface OAuth2Service {
    @Nonnull
    public String completeOAuth2Flow(@Nonnull HttpSession var1, @Nonnull String var2) throws OAuth2Exception;

    @Nonnull
    public List<OAuth2Provider> getConfiguredOAuth2Providers();

    @Nonnull
    public ClientToken getRefreshedToken(@Nonnull String var1) throws OAuth2Exception;

    @Nonnull
    public ClientTokenEntity getToken(@Nonnull String var1) throws OAuth2Exception;

    @Nonnull
    public OAuth2Result initialiseOAuth2Flow(@Nonnull HttpSession var1, @Nonnull String var2, @Nonnull UnaryOperator<String> var3) throws IllegalArgumentException;

    public static class OAuth2Provider {
        private final String id;
        private final String name;
        private final String type;

        public OAuth2Provider(String id, String name, String type) {
            this.id = Objects.requireNonNull(id, "id");
            this.name = Objects.requireNonNull(name, "name");
            this.type = Objects.requireNonNull(type, "type");
        }

        public String toString() {
            return String.format("%s - %s - OAuth 2.0", this.name, StringUtils.capitalize((String)this.type));
        }

        public String getId() {
            return this.id;
        }
    }

    public static class OAuth2Result {
        private final String flowId;
        private final String redirectUrl;

        public OAuth2Result(String flowId, String redirectUrl) {
            this.flowId = Objects.requireNonNull(flowId, "flowId");
            this.redirectUrl = Objects.requireNonNull(redirectUrl, "redirectUrl");
        }

        public String getFlowId() {
            return this.flowId;
        }

        public String getRedirectUrl() {
            return this.redirectUrl;
        }
    }
}

