/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestCreateRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class PullRequestImportRequest
extends PullRequestCreateRequest {
    private final String author;
    private final Instant createdDate;
    private final Instant closedDate;
    private final boolean draft;
    private final String fromRefDisplayId;
    private final String fromRefLatestCommit;
    private final Map<String, String> lastReviewCommitsByParticipant;
    private final Set<String> otherParticipants;
    private final Instant rescopedDate;
    private final long scopedId;
    private final PullRequestState state;
    private final Map<String, PullRequestParticipantStatus> statusesByParticipant;
    private final String toBranchDisplayId;
    private final String toBranchLatestCommit;
    private final Instant updatedDate;
    private final int version;

    private PullRequestImportRequest(@Nonnull Builder builder) {
        super((PullRequestCreateRequest.AbstractBuilder)builder);
        this.author = Objects.requireNonNull(builder.author, "author");
        this.createdDate = Objects.requireNonNull(builder.createdDate, "createdDate");
        this.closedDate = builder.closedDate;
        this.draft = builder.draft;
        this.fromRefDisplayId = Objects.requireNonNull(builder.fromRefDisplayId, "fromRefDisplayId");
        this.fromRefLatestCommit = Objects.requireNonNull(builder.fromRefLatestCommit, "fromRefLatestCommit");
        this.lastReviewCommitsByParticipant = ImmutableMap.copyOf(builder.lastReviewCommitsByParticipant);
        this.otherParticipants = ImmutableSet.copyOf(builder.otherParticipants);
        this.rescopedDate = Objects.requireNonNull(builder.rescopedDate, "rescopedDate");
        this.scopedId = Objects.requireNonNull(builder.scopedId, "scopedId");
        this.state = Objects.requireNonNull(builder.state, "state");
        this.statusesByParticipant = ImmutableMap.copyOf(builder.statusesByParticipant);
        this.toBranchDisplayId = Objects.requireNonNull(builder.toBranchDisplayId, "toBranchDisplayId");
        this.toBranchLatestCommit = Objects.requireNonNull(builder.toBranchLatestCommit, "toBranchLatestCommit");
        this.updatedDate = Objects.requireNonNull(builder.updatedDate, "updatedDate");
        this.version = Objects.requireNonNull(builder.version, "version");
    }

    @Nonnull
    public String getAuthor() {
        return this.author;
    }

    @Nonnull
    public Instant getCreatedDate() {
        return this.createdDate;
    }

    @Nonnull
    public Optional<Instant> getClosedDate() {
        return Optional.ofNullable(this.closedDate);
    }

    @Nonnull
    public String getFromRefDisplayId() {
        return this.fromRefDisplayId;
    }

    @Nonnull
    public String getFromRefLatestCommit() {
        return this.fromRefLatestCommit;
    }

    @Nonnull
    public Map<String, String> getLastReviewCommitsByParticipant() {
        return this.lastReviewCommitsByParticipant;
    }

    @Nonnull
    public Set<String> getOtherParticipants() {
        return this.otherParticipants;
    }

    public Instant getRescopedDate() {
        return this.rescopedDate;
    }

    public long getScopedId() {
        return this.scopedId;
    }

    @Nonnull
    public PullRequestState getState() {
        return this.state;
    }

    @Nonnull
    public Map<String, PullRequestParticipantStatus> getStatusesByParticipant() {
        return this.statusesByParticipant;
    }

    @Nonnull
    public String getToBranchDisplayId() {
        return this.toBranchDisplayId;
    }

    @Nonnull
    public String getToBranchLatestCommit() {
        return this.toBranchLatestCommit;
    }

    @Nonnull
    public Instant getUpdatedDate() {
        return this.updatedDate;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public static class Builder
    extends PullRequestCreateRequest.AbstractBuilder<Builder> {
        private final Map<String, String> lastReviewCommitsByParticipant = Maps.newHashMap();
        private final Set<String> otherParticipants = Sets.newHashSet();
        private final Map<String, PullRequestParticipantStatus> statusesByParticipant = Maps.newHashMap();
        private String author;
        private Instant createdDate;
        private Instant closedDate;
        private boolean draft;
        private String fromRefDisplayId;
        private String fromRefLatestCommit;
        private Instant rescopedDate;
        private Long scopedId;
        private PullRequestState state;
        private String toBranchDisplayId;
        private String toBranchLatestCommit;
        private Instant updatedDate;
        private Integer version;

        @Nonnull
        public PullRequestImportRequest build() {
            return new PullRequestImportRequest(this);
        }

        @Nonnull
        public Builder createdDate(@Nonnull Instant value) {
            this.createdDate = Objects.requireNonNull(value, "createdDate");
            return this.self();
        }

        @Nonnull
        public Builder closedDate(@Nullable Instant value) {
            this.closedDate = value;
            return this.self();
        }

        @Nonnull
        public Builder draft(boolean value) {
            this.draft = value;
            return this.self();
        }

        @Nonnull
        public Builder from(@Nonnull Repository repository, @Nonnull String branchId, @Nonnull String branchDisplayId, @Nonnull String branchLatestCommit) {
            this.fromRepository(repository);
            this.fromRefId(branchId);
            this.fromRefDisplayId = Objects.requireNonNull(branchDisplayId, "branchDisplayId");
            this.fromRefLatestCommit = Objects.requireNonNull(branchLatestCommit, "branchLatestCommit");
            return this.self();
        }

        @Nonnull
        public Builder participant(@Nonnull String user, @Nonnull PullRequestRole role, @Nonnull PullRequestParticipantStatus status, String lastReviewedCommit) {
            Objects.requireNonNull(user, "user");
            Objects.requireNonNull(role, "role");
            Objects.requireNonNull(status, "status");
            switch (role) {
                case AUTHOR: {
                    this.author = user;
                    break;
                }
                case REVIEWER: {
                    super.reviewer(user);
                    break;
                }
                default: {
                    this.otherParticipants.add(user);
                }
            }
            this.statusesByParticipant.put(user, status);
            if (StringUtils.isBlank((CharSequence)lastReviewedCommit)) {
                this.lastReviewCommitsByParticipant.remove(user);
            } else {
                this.lastReviewCommitsByParticipant.put(user, lastReviewedCommit);
            }
            return this.self();
        }

        @Nonnull
        public Builder rescopedDate(@Nonnull Instant value) {
            this.rescopedDate = Objects.requireNonNull(value, "rescopedDate");
            return this.self();
        }

        @Nonnull
        public Builder reviewer(@Nonnull String value) {
            this.participant(value, PullRequestRole.REVIEWER, PullRequestParticipantStatus.UNAPPROVED, null);
            return this.self();
        }

        @Nonnull
        public Builder reviewers(@Nonnull Set<String> values) {
            for (String reviewer : Objects.requireNonNull(values, "reviewers")) {
                this.participant(reviewer, PullRequestRole.REVIEWER, PullRequestParticipantStatus.UNAPPROVED, null);
            }
            return this.self();
        }

        @Nonnull
        public Builder scopedId(long value) {
            this.scopedId = value;
            return this.self();
        }

        @Nonnull
        public Builder state(@Nonnull PullRequestState value) {
            this.state = Objects.requireNonNull(value, "state");
            return this.self();
        }

        @Nonnull
        public Builder to(@Nonnull Repository repository, @Nonnull String branchId, @Nonnull String branchDisplayId, @Nonnull String branchLatestCommit) {
            this.toRepository(repository);
            this.toBranchId(branchId);
            this.toBranchDisplayId = Objects.requireNonNull(branchDisplayId, "branchDisplayId");
            this.toBranchLatestCommit = Objects.requireNonNull(branchLatestCommit, "branchLatestCommit");
            return this.self();
        }

        @Nonnull
        public Builder updatedDate(@Nonnull Instant value) {
            this.updatedDate = Objects.requireNonNull(value, "value");
            return this.self();
        }

        @Nonnull
        public Builder version(int value) {
            this.version = value;
            return this.self();
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

