/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.stash.internal.server.DataStoreSymbolicLinkDirectoryException;
import com.atlassian.stash.internal.server.InternalDataStore;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public final class DataStoreLayout {
    static final String PATH_PROPERTIES = "store.properties";
    static final String PROP_UUID = "store.uuid";
    static final String PROP_VERSION = "store.version";
    static final Version VERSION = new Version(new Integer[]{1});

    private DataStoreLayout() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is not intended to be instantiated");
    }

    @Nonnull
    public static Path getRepositoriesDir(@Nonnull DataStore store) {
        return Objects.requireNonNull(store, "store").getDir().resolve(Subdirectory.REPOSITORIES.path);
    }

    @Nonnull
    static Path getAttachmentsDir(@Nonnull InternalDataStore store) {
        Objects.requireNonNull(store, "store");
        return store.getDir().resolve(Subdirectory.ATTACHMENTS.path);
    }

    static void create(@Nonnull Path path) throws IOException {
        Objects.requireNonNull(path, "path");
        for (Subdirectory dir : Subdirectory.values()) {
            Path subdirectoryPath = path.resolve(dir.path);
            if (Files.isSymbolicLink(subdirectoryPath)) {
                throw new DataStoreSymbolicLinkDirectoryException(subdirectoryPath);
            }
            Files.createDirectories(subdirectoryPath, new FileAttribute[0]);
        }
    }

    @Nonnull
    static Path getHierarchyDir(@Nonnull DataStore store, @Nonnull String hierarchyId) {
        Objects.requireNonNull(hierarchyId, "hierarchyId");
        return DataStoreLayout.getRepositoriesDir(store).resolve(hierarchyId.substring(0, 2)).resolve(hierarchyId.substring(2));
    }

    @Nonnull
    static Path getRepositoryDir(@Nonnull DataStore store, @Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return DataStoreLayout.getHierarchyDir(store, repository.getHierarchyId()).resolve(String.valueOf(repository.getId()));
    }

    @VisibleForTesting
    static enum Subdirectory {
        ATTACHMENTS("attachments"),
        REPOSITORIES("repositories");

        final String path;

        private Subdirectory(String path) {
            this.path = Objects.requireNonNull(path, "path");
        }
    }
}

