/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.permission.PermissionVoters;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.security.authentication.AbstractAuthenticationToken;

public class StashUserAuthenticationToken
extends AbstractAuthenticationToken
implements Authentication {
    private final Map<String, Serializable> properties;
    private final ApplicationUser user;
    private final PermissionVoter voter;

    private StashUserAuthenticationToken(Builder builder) {
        super(Collections.emptySet());
        this.properties = builder.properties.build();
        this.user = builder.user;
        this.voter = (PermissionVoter)MoreObjects.firstNonNull((Object)builder.voter, (Object)PermissionVoters.alwaysAbstain());
        this.setAuthenticated(true);
    }

    @Nonnull
    public StashUserAuthenticationToken copyWithUser(@Nonnull ApplicationUser user) {
        Builder builder = new Builder(this).user(user);
        if (this.user == null || this.user.getId() != Objects.requireNonNull(user, "user").getId()) {
            builder.voter = null;
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StashUserAuthenticationToken that = (StashUserAuthenticationToken)((Object)o);
        return Objects.equals(this.user, that.user) && Objects.equals(this.properties, that.properties);
    }

    public Object getCredentials() {
        return null;
    }

    public String getName() {
        return this.user == null ? "<anonymous>" : this.user.getName();
    }

    public ApplicationUser getPrincipal() {
        return this.user;
    }

    @Nonnull
    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    @Nonnull
    public PermissionVoter getVoter() {
        return this.voter;
    }

    @Nonnull
    public Optional<ApplicationUser> getUser() {
        return Optional.ofNullable(this.user);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.user);
    }

    public String toString() {
        return "StashUserAuthenticationToken{user=" + String.valueOf(this.user) + ", voter=" + String.valueOf(this.voter) + "}";
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, Serializable> properties = ImmutableMap.builder();
        private ApplicationUser user;
        private PermissionVoter voter;

        public Builder() {
        }

        public Builder(@Nonnull StashUserAuthenticationToken token) {
            this.user = token.user;
            this.voter = token.voter;
        }

        @Nonnull
        public StashUserAuthenticationToken build() {
            return new StashUserAuthenticationToken(this);
        }

        @Nonnull
        public Builder property(@Nonnull String key, @Nonnull Serializable value) {
            this.properties.put((Object)Objects.requireNonNull(key, "key"), (Object)Objects.requireNonNull(value, "value"));
            return this;
        }

        @Nonnull
        public Builder properties(@Nonnull Map<String, Serializable> values) {
            this.properties.putAll(Objects.requireNonNull(values, "properties"));
            return this;
        }

        @Nonnull
        public Builder user(@Nullable ApplicationUser value) {
            this.user = value;
            return this;
        }

        @Nonnull
        public Builder voter(@Nullable PermissionVoter value) {
            this.voter = value;
            return this;
        }
    }
}

