/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.zdu;

import com.atlassian.bitbucket.util.Version;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class RollingUpgradeState {
    private final boolean upgradeModeEnabled;
    private final Version originalVersion;

    public RollingUpgradeState(boolean upgradeModeEnabled, @Nullable Version originalVersion) {
        this.upgradeModeEnabled = upgradeModeEnabled;
        if (upgradeModeEnabled) {
            Objects.requireNonNull(originalVersion, "originalVersion cannot be null when upgrade mode is enabled");
        }
        this.originalVersion = originalVersion;
    }

    public boolean isUpgradeModeEnabled() {
        return this.upgradeModeEnabled;
    }

    @Nonnull
    public Optional<Version> getOriginalVersion() {
        return Optional.ofNullable(this.originalVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RollingUpgradeState that = (RollingUpgradeState)o;
        return this.upgradeModeEnabled == that.upgradeModeEnabled && Objects.equals(this.originalVersion, that.originalVersion);
    }

    public int hashCode() {
        return Objects.hash(this.upgradeModeEnabled, this.originalVersion);
    }
}

