/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.extender;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

class BeanEventListenerScanner
implements BeanPostProcessor,
DisposableBean,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(BeanEventListenerScanner.class);
    private static final Object IGNORE = new Object();
    private final ReentrantLock lock;
    private final Map<String, Object> beansRegistered;
    private final Map<String, Object> beansUnscanned;
    private final BundleContext bundleContext;
    private final String bundleName;
    private final ServiceTracker<ListenerHandlersConfiguration, ListenerHandlersConfiguration> configurationTracker;
    private final ServiceTracker<EventPublisher, EventPublisher> eventPublisherTracker;
    private final ServiceRegistration<?> lifecycleAwareRegistration;
    private volatile boolean started;

    BeanEventListenerScanner(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.beansRegistered = new ConcurrentHashMap<String, Object>();
        this.beansUnscanned = new ConcurrentHashMap<String, Object>();
        this.bundleName = bundleContext.getBundle().getSymbolicName();
        this.lock = new ReentrantLock();
        this.lifecycleAwareRegistration = bundleContext.registerService(LifecycleAware.class.getName(), (Object)new EventListenerLifecycle(), null);
        this.configurationTracker = new ServiceTracker(bundleContext, ListenerHandlersConfiguration.class, new TriggeringTrackerCustomizer());
        this.eventPublisherTracker = new ServiceTracker(bundleContext, EventPublisher.class, new TriggeringTrackerCustomizer());
        this.configurationTracker.open();
        this.eventPublisherTracker.open();
    }

    public void destroy() throws Exception {
        this.unregisterEventListeners();
        this.configurationTracker.close();
        this.eventPublisherTracker.close();
        this.lifecycleAwareRegistration.unregister();
    }

    public int getOrder() {
        return 1;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        EventPublisher eventPublisher = null;
        ListenerHandlersConfiguration configuration = null;
        if (this.started) {
            eventPublisher = (EventPublisher)this.eventPublisherTracker.getService();
            configuration = (ListenerHandlersConfiguration)this.configurationTracker.getService();
        }
        if (eventPublisher != null && configuration != null) {
            this.registerIfEventListener(eventPublisher, configuration, beanName, bean);
        } else {
            this.beansUnscanned.put(beanName, bean);
            this.maybeRegisterUnscannedBeans();
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private static boolean isEventListener(ListenerHandlersConfiguration configuration, Object bean) {
        try {
            for (ListenerHandler handler : configuration.getListenerHandlers()) {
                if (handler.getInvokers(bean).isEmpty()) continue;
                return true;
            }
        }
        catch (NoClassDefFoundError e) {
            log.debug("Could not determine whether instance of {} was an event listener. Skipping.", bean.getClass(), (Object)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeRegisterUnscannedBeans() {
        EventPublisher eventPublisher = (EventPublisher)this.eventPublisherTracker.getService();
        ListenerHandlersConfiguration configuration = (ListenerHandlersConfiguration)this.configurationTracker.getService();
        if (this.started && !this.beansUnscanned.isEmpty() && eventPublisher != null && configuration != null) {
            this.lock.lock();
            try {
                Iterator<Map.Entry<String, Object>> it = this.beansUnscanned.entrySet().iterator();
                HashSet<String> newlyRegistered = new HashSet<String>();
                while (it.hasNext()) {
                    Map.Entry<String, Object> entry = it.next();
                    Object bean = entry.getValue();
                    String name = entry.getKey();
                    if (this.registerIfEventListener(eventPublisher, configuration, name, bean)) {
                        newlyRegistered.add(name);
                    }
                    it.remove();
                }
                if (log.isDebugEnabled() && !newlyRegistered.isEmpty()) {
                    log.debug("{}: registered [{}] as event listener", (Object)this.bundleName, (Object)newlyRegistered.stream().collect(Collectors.joining(", ")));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private boolean registerIfEventListener(EventPublisher eventPublisher, ListenerHandlersConfiguration configuration, String name, Object bean) {
        try {
            Object registeredBean = this.beansRegistered.get(name);
            if (registeredBean != null) {
                if (registeredBean != IGNORE && registeredBean != bean) {
                    eventPublisher.unregister(registeredBean);
                    log.debug("{}: unregistering {} as an event listener because it is either a prototype bean or an uncached plugin module. If the module should be automatically registered with the EventPublisher, please define the bean in the Spring context and use a bean: prefix in the atlassian-plugin.xml", (Object)this.bundleName, (Object)name);
                    this.beansRegistered.put(name, IGNORE);
                }
            } else if (BeanEventListenerScanner.isEventListener(configuration, bean)) {
                eventPublisher.register(bean);
                this.beansRegistered.put(name, bean);
                return true;
            }
        }
        catch (RuntimeException e) {
            log.warn("{}: could not register {} as an event listener (reason: {})", new Object[]{this.bundleName, name, e.getMessage(), log.isDebugEnabled() ? e : null});
        }
        return false;
    }

    private void unregisterEventListeners() {
        EventPublisher eventPublisher = (EventPublisher)this.eventPublisherTracker.getService();
        Iterator<Object> it = this.beansRegistered.values().iterator();
        if (log.isDebugEnabled() && !this.beansRegistered.isEmpty()) {
            String beanNames = this.beansRegistered.keySet().stream().collect(Collectors.joining(", "));
            if (eventPublisher != null) {
                log.debug("{}: unregistering [{}] as event listener", (Object)this.bundleName, (Object)beanNames);
            } else {
                log.debug("{}: could not unregister [{}] as event listener; the event publisher is no longer available", (Object)this.bundleName, (Object)beanNames);
            }
        }
        while (it.hasNext()) {
            Object bean = it.next();
            it.remove();
            if (eventPublisher == null || IGNORE == bean) continue;
            try {
                eventPublisher.unregister(bean);
            }
            catch (RuntimeException e) {
                log.debug("{}: Could not unregister event listener of type {}", new Object[]{this.bundleName, bean.getClass().getName(), e});
            }
        }
    }

    private class EventListenerLifecycle
    implements LifecycleAware {
        private EventListenerLifecycle() {
        }

        public void onStart() {
            BeanEventListenerScanner.this.started = true;
            BeanEventListenerScanner.this.maybeRegisterUnscannedBeans();
        }

        public void onStop() {
            BeanEventListenerScanner.this.started = false;
            BeanEventListenerScanner.this.unregisterEventListeners();
        }
    }

    private class TriggeringTrackerCustomizer<T>
    implements ServiceTrackerCustomizer<T, T> {
        private TriggeringTrackerCustomizer() {
        }

        public T addingService(ServiceReference<T> serviceReference) {
            Object service = BeanEventListenerScanner.this.bundleContext.getService(serviceReference);
            BeanEventListenerScanner.this.maybeRegisterUnscannedBeans();
            return (T)service;
        }

        public void modifiedService(ServiceReference<T> serviceReference, T service) {
        }

        public void removedService(ServiceReference<T> serviceReference, T service) {
            BeanEventListenerScanner.this.bundleContext.ungetService(serviceReference);
        }
    }
}

