/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.extender;

import com.atlassian.bitbucket.internal.plugin.extender.BeanEventListenerScanner;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.gemini.blueprint.extender.OsgiBeanFactoryPostProcessor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class PluginOsgiBeanFactoryPostProcessor
implements OsgiBeanFactoryPostProcessor {
    private static final Set<String> BLACKLISTED_PLUGIN_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("com.atlassian.activeobjects.activeobjects-plugin", "com.atlassian.analytics.analytics-client", "com.atlassian.analytics.analytics-whitelist", "com.atlassian.applinks.applinks-basicauth-plugin", "com.atlassian.applinks.applinks-cors-plugin", "com.atlassian.applinks.applinks-oauth-plugin", "com.atlassian.applinks.applinks-plugin", "com.atlassian.applinks.applinks-trustedapps-plugin", "com.atlassian.auiplugin", "com.atlassian.crowd.embedded.admin", "com.atlassian.integration.jira.jira-integration-plugin", "com.atlassian.jwt.jwt-plugin", "com.atlassian.oauth.atlassian-oauth-consumer-spi", "com.atlassian.oauth.atlassian-oauth-service-provider-spi", "com.atlassian.oauth.consumer", "com.atlassian.oauth.consumer.sal", "com.atlassian.oauth.serviceprovider", "com.atlassian.oauth.serviceprovider.sal", "com.atlassian.plugins.atlassian-client-resource", "com.atlassian.plugins.atlassian-nav-links-plugin", "com.atlassian.plugins.atlassian-plugins-webresource-plugin", "com.atlassian.plugins.atlassian-plugins-webresource-rest", "com.atlassian.plugins.atlassian-remote-event-common-plugin", "com.atlassian.plugins.atlassian-remote-event-consumer-plugin", "com.atlassian.plugins.atlassian-remote-event-producer-plugin", "com.atlassian.plugins.issue-status-plugin", "com.atlassian.plugins.jquery", "com.atlassian.plugins.remote-link-aggregator-plugin", "com.atlassian.plugins.shortcuts.atlassian-shortcuts-plugin", "com.atlassian.prettyurls.atlassian-pretty-urls-plugin", "com.atlassian.scala.plugins.scala-2.11-provider-plugin", "com.atlassian.soy.soy-template-plugin", "com.atlassian.stash.plugins.stash-remote-event-bitbucket-server-spi", "com.atlassian.support.stp", "com.atlassian.templaterenderer.api", "com.atlassian.templaterenderer.atlassian-template-renderer-velocity1.6-plugin", "com.atlassian.upm.atlassian-universal-plugin-manager-plugin", "com.atlassian.webhooks.atlassian-webhooks-plugin")));

    public void postProcessBeanFactory(BundleContext bundleContext, ConfigurableListableBeanFactory beanFactory) throws BeansException, InvalidSyntaxException, BundleException {
        PluginOsgiBeanFactoryPostProcessor.getPluginKey(bundleContext).ifPresent(pluginKey -> this.registerEventListenerRegistrar((String)pluginKey, bundleContext, beanFactory));
    }

    private static Optional<String> getPluginKey(BundleContext bundleContext) {
        return Optional.ofNullable((String)bundleContext.getBundle().getHeaders().get("Atlassian-Plugin-Key"));
    }

    private void registerEventListenerRegistrar(String pluginKey, BundleContext bundleContext, ConfigurableListableBeanFactory beanFactory) {
        if (!BLACKLISTED_PLUGIN_KEYS.contains(pluginKey)) {
            beanFactory.addBeanPostProcessor((BeanPostProcessor)new BeanEventListenerScanner(bundleContext));
        }
    }
}

