/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.repositorymanagement;

import com.atlassian.bitbucket.dmz.repositorymanagement.DmzRepositoryManagementService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.RepositorySize;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.mirror.hash.MirrorHashDao;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.repository.RepositorySizeCache;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=DmzRepositoryManagementService.class)
@Profiled
@Service(value="repositoryManagementService")
@Transactional(readOnly=true)
public class DefaultRepositoryManagementService
implements DmzRepositoryManagementService {
    private static final Logger log = LoggerFactory.getLogger(DefaultRepositoryManagementService.class);
    private final MirrorHashDao mirrorHashDao;
    private final RepositoryActivityDao repositoryActivityDao;
    private final RepositoryDao repositoryDao;
    private final RepositorySizeCache repositorySizeCache;

    @Autowired
    public DefaultRepositoryManagementService(MirrorHashDao mirrorHashDao, RepositoryActivityDao repositoryActivityDao, RepositoryDao repositoryDao, RepositorySizeCache repositorySizeCache) {
        this.mirrorHashDao = mirrorHashDao;
        this.repositoryActivityDao = repositoryActivityDao;
        this.repositoryDao = repositoryDao;
        this.repositorySizeCache = repositorySizeCache;
    }

    @Nonnull
    public Map<String, Long> countByHierarchies(@Nonnull Set<String> hierarchyIds) {
        return this.repositoryDao.countByHierarchies(hierarchyIds);
    }

    public Date getRecentActivity(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        try (Stream mirrorHashes = this.mirrorHashDao.streamByRepositoryIds((Collection)ImmutableSet.of((Object)repository.getId()));){
            Date date = mirrorHashes.findFirst().map(hashes -> {
                Date contentHashDate = hashes.getContentUpdatedDate();
                Date metadataHashDate = hashes.getMetadataUpdatedDate();
                log.debug("Mirror hash found for repository (id={}): contentHashDate={}, metadataHashDate={}", new Object[]{repository.getId(), contentHashDate, metadataHashDate});
                return (Date)ObjectUtils.max((Comparable[])new Date[]{contentHashDate, metadataHashDate});
            }).orElseGet(() -> {
                log.debug("Mirror hash not found, querying from activity table for repository (id={})", (Object)repository.getId());
                return this.repositoryActivityDao.findMostRecentActivityTime(repository.getId());
            });
            return date;
        }
    }

    public RepositorySize getSize(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return this.repositorySizeCache.get(repository);
    }
}

