/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.codeinsights.annotation.SingleAddInsightAnnotationRequest;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.internal.codeinsights.dao.InternalInsightAnnotation;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@AsynchronousPreferred
@EventName(value="stash.codeinsights.annotation.updated")
@TransactionAware
public class AnalyticsAnnotationUpdatedEvent
extends RepositoryEvent {
    private final SingleAddInsightAnnotationRequest annotation;
    private final InternalInsightAnnotation oldAnnotation;

    public AnalyticsAnnotationUpdatedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull InternalInsightAnnotation oldAnnotation, @Nonnull SingleAddInsightAnnotationRequest annotation) {
        super(source, repository);
        this.oldAnnotation = oldAnnotation;
        this.annotation = annotation;
    }

    @Nonnull
    public String getOldSeverity() {
        return this.oldAnnotation.getSeverity().name();
    }

    @Nullable
    public String getOldType() {
        return this.oldAnnotation.getType().map(Enum::name).orElse(null);
    }

    @Nonnull
    public String getSeverity() {
        return this.annotation.getSeverity().name();
    }

    @Nullable
    public String getType() {
        return this.annotation.getType() == null ? null : this.annotation.getType().name();
    }
}

