/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.annotation;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationCallback;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationLocation;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationsLimitExceededException;
import com.atlassian.bitbucket.codeinsights.annotation.BulkAddInsightAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.annotation.DeleteAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.annotation.InsightAnnotation;
import com.atlassian.bitbucket.codeinsights.annotation.InsightAnnotationService;
import com.atlassian.bitbucket.codeinsights.annotation.SearchAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.annotation.SetInsightAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.annotation.SingleAddInsightAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.report.InsightReport;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.codeinsights.analytics.AnalyticsAnnotationCreatedEvent;
import com.atlassian.bitbucket.internal.codeinsights.analytics.AnalyticsAnnotationUpdatedEvent;
import com.atlassian.bitbucket.internal.codeinsights.analytics.AnalyticsAnnotationsCreatedEvent;
import com.atlassian.bitbucket.internal.codeinsights.analytics.AnalyticsAnnotationsDeletedEvent;
import com.atlassian.bitbucket.internal.codeinsights.annotation.FileChanges;
import com.atlassian.bitbucket.internal.codeinsights.annotation.PullRequestAnnotationHelper;
import com.atlassian.bitbucket.internal.codeinsights.annotation.SourceDiff;
import com.atlassian.bitbucket.internal.codeinsights.dao.InsightAnnotationDao;
import com.atlassian.bitbucket.internal.codeinsights.dao.InsightReportDao;
import com.atlassian.bitbucket.internal.codeinsights.dao.InternalInsightAnnotation;
import com.atlassian.bitbucket.internal.codeinsights.dao.InternalInsightReport;
import com.atlassian.bitbucket.internal.codeinsights.dao.SqlUtils;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.auth.OAuthRequestVerifierFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="insightAnnotationService")
public class DefaultInsightAnnotationService
implements InsightAnnotationService {
    static final String ANNOTATIONS_PER_REPORT = "plugin.bitbucket-code-insights.report.annotations.max";
    private static final int DEFAULT_ANNOTATIONS_PER_REPORT = 1000;
    private static final int MAX_ANNOTATIONS_PER_PAGE = 1000;
    private static final int MAX_FILE_FILTER = 2000;
    private final AuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final InsightAnnotationDao insightAnnotationDao;
    private final InsightReportDao insightReportDao;
    private final int maxAnnotationsPerReport;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final PullRequestAnnotationHelper pullRequestAnnotationHelper;
    private final OAuthRequestVerifierFactory requestVerifierFactory;
    private final TransactionTemplate transactionTemplate;

    public DefaultInsightAnnotationService(PullRequestAnnotationHelper pullRequestAnnotationHelper, AuthenticationContext authenticationContext, EventPublisher eventPublisher, InsightAnnotationDao insightAnnotationDao, InsightReportDao insightReportDao, I18nService i18nService, PermissionService permissionService, PermissionValidationService permissionValidationService, ApplicationPropertiesService propertiesService, OAuthRequestVerifierFactory requestVerifierFactory, TransactionTemplate transactionTemplate) {
        this.pullRequestAnnotationHelper = pullRequestAnnotationHelper;
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.insightAnnotationDao = insightAnnotationDao;
        this.insightReportDao = insightReportDao;
        this.permissionValidationService = permissionValidationService;
        this.permissionService = permissionService;
        this.requestVerifierFactory = requestVerifierFactory;
        this.transactionTemplate = transactionTemplate;
        this.maxAnnotationsPerReport = propertiesService.getPluginProperty(ANNOTATIONS_PER_REPORT, 1000);
    }

    public void addAnnotations(@Nonnull BulkAddInsightAnnotationRequest request) {
        this.validateUserIsEitherBasicOrOAuth();
        InsightReport report = Objects.requireNonNull(request, "request").getReport();
        this.permissionValidationService.validateForRepository(report.getRepository(), Permission.REPO_READ);
        InternalInsightReport internalReport = (InternalInsightReport)report;
        this.validateCanAdd(internalReport);
        List<String> externalIds = request.getAnnotationRequests().stream().map(SingleAddInsightAnnotationRequest::getExternalId).filter(Objects::nonNull).collect(Collectors.toList());
        this.validateNoDuplicates(externalIds);
        try {
            this.transactionTemplate.execute(() -> {
                this.verifyReportExists(report.getRepository(), report.getCommitId(), report.getKey());
                this.validateAnnotationLimit(internalReport, request.getCount());
                if (this.insightAnnotationDao.hasAnnotations(internalReport.getID(), externalIds)) {
                    throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.annotation.ext.id.already.exists", new Object[]{internalReport.getKey()}));
                }
                request.getAnnotationRequests().forEach(annotation -> this.createAnnotation(internalReport, (SingleAddInsightAnnotationRequest)annotation));
                return null;
            });
        }
        catch (RuntimeException e) {
            if (SqlUtils.isForeignKeyViolation(e)) {
                throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.report.notexist", new Object[]{report.getKey(), report.getCommitId()}), (Throwable)e);
            }
            throw e;
        }
        this.eventPublisher.publish((Object)new AnalyticsAnnotationsCreatedEvent(this, internalReport.getRepository(), request.getAnnotationRequests()));
    }

    public void delete(@Nonnull DeleteAnnotationRequest request) {
        this.validateUserIsEitherBasicOrOAuth();
        Objects.requireNonNull(request, "request");
        Repository repository = request.getRepository();
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_READ);
        this.transactionTemplate.execute(() -> {
            InternalInsightReport report = this.insightReportDao.get(repository.getId(), request.getCommitId(), request.getReportKey());
            if (report != null) {
                this.validateCanDeleteAnnotations(report);
                int count = this.insightAnnotationDao.deleteByReportAndExternalIds(report.getID(), request.getExternalIds());
                this.eventPublisher.publish((Object)new AnalyticsAnnotationsDeletedEvent(this, repository, count));
            }
            return null;
        });
    }

    @Nonnull
    public Optional<InsightAnnotation> get(@Nonnull InsightReport report, @Nonnull String externalId) {
        return this.insightAnnotationDao.getByExternalId(((InternalInsightReport)report).getID(), externalId).map(InternalInsightAnnotation::initialize);
    }

    public void set(@Nonnull SetInsightAnnotationRequest request) {
        this.validateUserIsEitherBasicOrOAuth();
        InternalInsightReport report = (InternalInsightReport)Objects.requireNonNull(request, "request").getReport();
        String externalId = request.getAnnotationRequest().getExternalId();
        this.permissionValidationService.validateForRepository(report.getRepository(), Permission.REPO_READ);
        this.validateCanAdd(report);
        InternalInsightAnnotation existingAnnotation = (InternalInsightAnnotation)this.transactionTemplate.execute(() -> {
            InternalInsightAnnotation existing;
            this.verifyReportExists(report.getRepository(), report.getCommitId(), report.getKey());
            InternalInsightAnnotation internalInsightAnnotation = existing = externalId == null ? null : (InternalInsightAnnotation)this.insightAnnotationDao.getByExternalId(report.getID(), externalId).orElse(null);
            if (existing == null) {
                this.validateAnnotationLimit(report, 1);
            } else {
                this.insightAnnotationDao.delete(existing.getID());
            }
            this.createAnnotation((InternalInsightReport)request.getReport(), request.getAnnotationRequest());
            return existing;
        });
        if (existingAnnotation == null) {
            this.eventPublisher.publish((Object)new AnalyticsAnnotationCreatedEvent(this, report.getRepository(), request.getAnnotationRequest()));
        } else {
            existingAnnotation.initialize();
            this.eventPublisher.publish((Object)new AnalyticsAnnotationUpdatedEvent(this, report.getRepository(), existingAnnotation, request.getAnnotationRequest()));
        }
    }

    public void stream(@Nonnull SearchAnnotationRequest request, @Nonnull AnnotationCallback callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        this.permissionValidationService.validateForRepository(this.getTargetRepository(request), Permission.REPO_READ);
        int totalAnnotationCount = this.insightAnnotationDao.countForCommit(request.getRepository().getId(), request.getCommitId());
        callback.onStart(totalAnnotationCount);
        if (totalAnnotationCount == 0) {
            callback.onEnd(false);
            return;
        }
        SourceDiff sourceDiff = request.getPullRequest().flatMap(pullRequest -> {
            if (request.getAnnotationLocation() == AnnotationLocation.ALL) {
                return Optional.empty();
            }
            return Optional.of(this.pullRequestAnnotationHelper.getSourceDiff((PullRequest)pullRequest, request.getFilePaths()));
        }).orElseGet(() -> new SourceDiff.Builder().fileChanges(request.getFilePaths().stream().collect(Collectors.toMap(Function.identity(), path -> new FileChanges.Builder().build()))).build());
        this.stream(request, callback, sourceDiff);
    }

    private static String toASCIIString(URI url) {
        return url == null ? null : url.toASCIIString();
    }

    private void createAnnotation(InternalInsightReport internalReport, SingleAddInsightAnnotationRequest annotation) {
        this.insightAnnotationDao.create(internalReport.getID(), annotation.getExternalId(), annotation.getLine(), DefaultInsightAnnotationService.toASCIIString(annotation.getLink()), annotation.getMessage(), StringUtils.stripToNull((String)annotation.getPath()), annotation.getSeverity(), annotation.getType());
    }

    private Optional<Integer> getCurrentUserId() {
        return Optional.ofNullable(this.authenticationContext.getCurrentUser()).map(ApplicationUser::getId);
    }

    private Repository getTargetRepository(SearchAnnotationRequest request) {
        return request.getPullRequest().map(pullRequest -> pullRequest.getToRef().getRepository()).orElseGet(() -> ((SearchAnnotationRequest)request).getRepository());
    }

    private boolean isAnnotationOnModifiedLine(InternalInsightAnnotation annotation, FileChanges file, AnnotationLocation annotationLocation) {
        if (file == null || annotationLocation != AnnotationLocation.LINES) {
            return true;
        }
        int lineNumber = annotation.getLine();
        if (lineNumber == 0) {
            return true;
        }
        if (file.getLineRanges().isEmpty() && !file.isTruncated()) {
            return true;
        }
        return file.getLineRanges().stream().anyMatch(lineRange -> lineRange.getStart() <= lineNumber && lineNumber <= lineRange.getEnd());
    }

    private void stream(SearchAnnotationRequest request, AnnotationCallback callback, SourceDiff sourceDiff) {
        Page<InternalInsightAnnotation> page;
        boolean truncated;
        boolean bl = truncated = sourceDiff.isTruncated() || sourceDiff.getFileChanges().size() > 2000;
        if (request.getPullRequest().isPresent() && !request.getFilePaths().isEmpty() && sourceDiff.getFileChanges().isEmpty()) {
            callback.onEnd(truncated);
            return;
        }
        PageRequest pageRequest = PageUtils.newRequest((int)0, (int)1000);
        do {
            Set<String> fileChanges = sourceDiff.getFileChanges().keySet().stream().limit(2000L).collect(Collectors.toSet());
            page = this.insightAnnotationDao.search(request.getRepository().getId(), request.getCommitId(), request.getReportKeys(), request.getExternalIds(), fileChanges, request.getSeverities(), request.getTypes(), pageRequest);
            pageRequest = page.getNextPageRequest();
        } while (page.stream().filter(annotation -> this.isAnnotationOnModifiedLine((InternalInsightAnnotation)annotation, sourceDiff.getFileChanges().get(annotation.getInternalPath()), request.getAnnotationLocation())).map(InternalInsightAnnotation::initialize).allMatch(arg_0 -> ((AnnotationCallback)callback).onAnnotation(arg_0)) && !page.getIsLastPage());
        callback.onEnd(truncated);
    }

    private void validateAnnotationLimit(InternalInsightReport report, int count) {
        int existing = this.insightAnnotationDao.countForReport(report.getID());
        if (existing + count > this.maxAnnotationsPerReport) {
            throw new AnnotationsLimitExceededException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.annotation.too.many", new Object[]{this.maxAnnotationsPerReport}), existing, this.maxAnnotationsPerReport);
        }
    }

    private void validateCanAdd(InternalInsightReport report) {
        if (report.getAuthorId().equals(this.getCurrentUserId())) {
            return;
        }
        throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.annotation.create", new Object[0]));
    }

    private void validateCanDeleteAnnotations(InternalInsightReport report) {
        if (report.getAuthorId().equals(this.getCurrentUserId()) || this.permissionService.hasRepositoryPermission(report.getRepository(), Permission.REPO_ADMIN)) {
            return;
        }
        throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.annotation.delete.author", new Object[0]));
    }

    private void validateNoDuplicates(List<String> externalIds) {
        if ((long)externalIds.size() != externalIds.stream().distinct().count()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.annotation.duplicate.ext.id", new Object[0]));
        }
    }

    private void validateUserIsEitherBasicOrOAuth() {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null ^ this.requestVerifierFactory.getInstance(null).isVerified()) {
            return;
        }
        throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.anonymous", new Object[0]));
    }

    private void verifyReportExists(Repository repository, String commitId, String key) {
        if (!this.insightReportDao.reportExists(repository.getId(), commitId, key)) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.report.notexist", new Object[]{key, commitId}));
        }
    }
}

