/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.dao;

import com.atlassian.bitbucket.codeinsights.report.InsightReportData;
import com.atlassian.bitbucket.codeinsights.report.InsightResult;
import com.atlassian.bitbucket.internal.codeinsights.dao.AoInsightReport;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.UrlUtils;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.List;
import java.util.Optional;

public class PartialAoInsightReport {
    private final AoInsightReport delegate;
    private List<InsightReportData> data;
    private URI link;
    private URI logoUrl;
    private Repository repository;
    private InsightResult result;

    public PartialAoInsightReport(AoInsightReport delegate) {
        this.delegate = delegate;
    }

    @Nonnull
    public Optional<Integer> getAuthorId() {
        return Optional.ofNullable(this.delegate.getInternalAuthorId());
    }

    @Nonnull
    public Optional<String> getCoverageProviderKey() {
        return Optional.ofNullable(this.delegate.getInternalCoverageProviderKey());
    }

    @Nonnull
    public List<InsightReportData> getData() {
        return this.data;
    }

    @Nonnull
    public Optional<String> getDetails() {
        return Optional.ofNullable(this.delegate.getInternalDetails());
    }

    @Nonnull
    public Optional<URI> getLink() {
        return Optional.ofNullable(this.link);
    }

    @Nonnull
    public Optional<URI> getLogoUrl() {
        return Optional.ofNullable(this.logoUrl);
    }

    @Nonnull
    public Optional<String> getReporter() {
        return Optional.ofNullable(this.delegate.getInternalReporter());
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public Optional<InsightResult> getResult() {
        return Optional.ofNullable(this.result);
    }

    public void initialize(@Nonnull Repository repository, @Nonnull List<InsightReportData> data) {
        this.repository = repository;
        this.data = data;
        this.link = UrlUtils.uncheckedCreateURI((String)this.delegate.getInternalLink());
        this.logoUrl = UrlUtils.uncheckedCreateURI((String)this.delegate.getInternalLogoUrl());
        this.result = InsightResult.fromId((Integer)this.delegate.getResultId()).orElse(null);
    }
}

