/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.dao.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.internal.codeinsights.dao.AoInsightReport;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Locale;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateToV1UpgradeTask
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(MigrateToV1UpgradeTask.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects ao) {
        log.debug("Attempting code insights report key data upgrade on model version {}", (Object)modelVersion.toString());
        Preconditions.checkState((boolean)modelVersion.isSame(ModelVersion.valueOf((String)"0")), (Object)"This task can only upgrade from version 0 to 1");
        log.info("Starting to migrate code insights report key data");
        ao.migrate(new Class[]{AoInsightReport.class});
        PageUtils.toStream(pageRequest -> MigrateToV1UpgradeTask.pageQuery(ao, pageRequest), (int)100).forEach(report -> {
            String lowerKey = report.getKey().toLowerCase(Locale.US);
            if (!report.getKey().equals(lowerKey)) {
                report.setKey(lowerKey);
                report.save();
            }
        });
        log.info("Migration of code insights report key data is complete");
    }

    private static Page<AoInsightReport> pageQuery(ActiveObjects ao, PageRequest pageRequest) {
        Query query = AoUtils.restrict((Query)Query.select().order("ID"), (PageRequest)pageRequest);
        Page page = PageUtils.createPage(Arrays.asList((AoInsightReport[])ao.find(AoInsightReport.class, query)), (PageRequest)pageRequest);
        log.info("Migrating items {} to {}.", (Object)page.getStart(), (Object)(page.getStart() + page.getSize()));
        return page;
    }
}

