/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.mergecheck;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.bitbucket.internal.codeinsights.mergecheck.InsightReportCondition;
import com.atlassian.bitbucket.internal.codeinsights.mergecheck.InternalInsightMergeCheckService;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightReportCondition;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LicensedOnly
public class InsightMergeCheckServlet
extends HttpServlet {
    private static final String RESOURCE_KEY = "com.atlassian.bitbucket.server.bitbucket-code-insights:page-templates";
    private static final String SETTINGS_PAGE_CONTEXT = "bitbucket.page.code-insights.settings";
    private static final String TEMPLATE_KEY = "bitbucketCodeinsights.internal.page.code.insights.codeinsights.codeInsightsSettings";
    private static final Logger log = LoggerFactory.getLogger(InsightMergeCheckServlet.class);
    private final InternalInsightMergeCheckService mergeCheckService;
    private final NavBuilder navBuilder;
    private final PageBuilderService pageBuilderService;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final ProjectService projectService;
    private final RepositoryService repositoryService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public InsightMergeCheckServlet(InternalInsightMergeCheckService mergeCheckService, NavBuilder navBuilder, PageBuilderService pageBuilderService, PermissionService permissionService, PermissionValidationService permissionValidationService, ProjectService projectService, RepositoryService repositoryService, SoyTemplateRenderer soyTemplateRenderer) {
        this.mergeCheckService = mergeCheckService;
        this.navBuilder = navBuilder;
        this.pageBuilderService = pageBuilderService;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        Optional<Scope> opScope = this.getScope(pathInfo);
        if (!opScope.isPresent()) {
            resp.sendError(404);
            return;
        }
        Scope scope = opScope.get();
        this.validateAdminPermissions(scope);
        final ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                contextBuilder.put((Object)"project", (Object)scope.getProject());
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                Project project = scope.getProject();
                contextBuilder.put((Object)"project", (Object)project);
                contextBuilder.put((Object)"repository", (Object)scope.getRepository());
                if (InsightMergeCheckServlet.this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
                    contextBuilder.put((Object)"inheritUrl", (Object)InsightMergeCheckServlet.this.navBuilder.pluginServlets().path(new String[]{"insights", "projects", project.getKey()}).buildRelative());
                }
                return null;
            }
        });
        contextBuilder.put((Object)"scopeType", (Object)scope.getType());
        List conditions = PageUtils.toStream(pageRequest -> this.mergeCheckService.getInsightReportConditions(scope, pageRequest), (int)25).collect(Collectors.toList());
        contextBuilder.put((Object)"settings", conditions.stream().filter(condition -> condition.getScope().getType() == scope.getType()).collect(Collectors.toMap(InsightReportCondition::getReportKey, RestInsightReportCondition::new, (k1, k2) -> {
            log.warn("CodeInsights conditions with duplicate Keys '{}' detected, ignoring the second one: {}, {}", new Object[]{k1.getReportKey(), k1, k2});
            return k1;
        })));
        contextBuilder.put((Object)"inheritedSettings", conditions.stream().filter(condition -> condition.getScope().getType() != scope.getType()).map(RestInsightReportCondition::new).collect(Collectors.toMap(RestInsightReportCondition::getReportKey, Function.identity(), (k1, k2) -> {
            log.warn("CodeInsights conditions with duplicate Keys '{}' detected, ignoring the second one: {}, {}", new Object[]{k1.getReportKey(), k1, k2});
            return k1;
        })));
        this.prepareResponse(resp);
        try {
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), RESOURCE_KEY, TEMPLATE_KEY, (Map)contextBuilder.build());
        }
        catch (SoyException soyException) {
            this.handleSoyError(soyException);
        }
    }

    private Optional<Scope> getScope(String pathInfo) {
        if (Strings.isNullOrEmpty((String)pathInfo)) {
            return Optional.empty();
        }
        String[] pathParts = pathInfo.substring(1).split("/");
        switch (pathParts.length) {
            case 2: {
                return Optional.ofNullable(this.projectService.getByKey(pathParts[1])).map(Scopes::project);
            }
            case 4: {
                return Optional.ofNullable(this.repositoryService.getBySlug(pathParts[1], pathParts[3])).map(Scopes::repository);
            }
        }
        return Optional.empty();
    }

    private void handleSoyError(SoyException e) throws IOException, ServletException {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new ServletException((Throwable)e);
    }

    private void prepareResponse(HttpServletResponse response) {
        this.pageBuilderService.assembler().resources().requireContext(SETTINGS_PAGE_CONTEXT);
        response.setContentType("text/html;charset=UTF-8");
    }

    private void validateAdminPermissions(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                InsightMergeCheckServlet.this.permissionValidationService.validateForProject(scope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                InsightMergeCheckServlet.this.permissionValidationService.validateForRepository(scope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }
}

