/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.codeinsights.coverage.CodeCoverageService;
import com.atlassian.bitbucket.internal.codeinsights.rest.JsonCodeCoverageCallback;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/coverage")
public class CommitCodeCoverageResource {
    private final CodeCoverageService coverageService;
    private final I18nService i18nService;

    @Inject
    public CommitCodeCoverageResource(CodeCoverageService coverageService, I18nService i18nService) {
        this.coverageService = coverageService;
        this.i18nService = i18nService;
    }

    @GET
    @Path(value="{path:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getFileCoverage(final @BeanParam RepositoryResolver repositoryResolver, final @PathParam(value="commitId") String commitId, final @PathParam(value="path") String path, final @BeanParam PageRequestResolver pageRequestResolver) {
        if (commitId.isBlank()) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.codeinsights.coverage.commit.required", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.codeinsights.coverage.path.required", new Object[0]));
        }
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws WebApplicationException {
                CommitCodeCoverageResource.this.coverageService.streamCoverage(repositoryResolver.getRepository(), commitId, path, new JsonCodeCoverageCallback(writer, pageRequestResolver.getPageRequest()), pageRequestResolver.getPageRequest());
            }
        }).build();
    }
}

