/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.internal.codeinsights.mergecheck.InsightReportCondition;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.scope.RestScope;
import com.atlassian.bitbucket.scope.Scope;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;

public class RestInsightReportCondition
extends RestMapEntity
implements InsightReportCondition {
    static final String MIN_SEVERITY = "minProhibitedSeverity";
    static final String MUST_PASS = "mustPass";
    static final String REPORT_KEY = "reportKey";
    static final String SCOPE = "scope";

    public RestInsightReportCondition() {
    }

    public RestInsightReportCondition(InsightReportCondition insightReportCondition) {
        insightReportCondition.getMinimumProhibitedSeverity().ifPresent(minimumProhibitedSeverity -> this.put(MIN_SEVERITY, minimumProhibitedSeverity.name()));
        this.put(REPORT_KEY, insightReportCondition.getReportKey());
        this.put(MUST_PASS, insightReportCondition.isMustPass());
        this.put(SCOPE, new RestScope(insightReportCondition.getScope()));
    }

    @Override
    @Nonnull
    public Optional<AnnotationSeverity> getMinimumProhibitedSeverity() {
        String maxSeverityString = this.getStringProperty(MIN_SEVERITY);
        if (maxSeverityString == null) {
            return Optional.empty();
        }
        return Optional.of(AnnotationSeverity.valueOf((String)maxSeverityString));
    }

    @Override
    @Nonnull
    public String getReportKey() {
        return this.getStringProperty(REPORT_KEY);
    }

    @Override
    @Nonnull
    @NotNull
    public Scope getScope() {
        return RestScope.valueOf((Object)this.get(SCOPE));
    }

    @Override
    public boolean isMustPass() {
        return this.getBoolProperty(MUST_PASS, false);
    }
}

